package fred;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;

import com.lowagie.text.Document;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;

public class SwingInPDF {
	
public static void main(String[] args) {
	PdfWriter pdfwriter;
	Document document = new Document(PageSize.A4);
	try {
		FileInputStream fis = new FileInputStream("HelloSerial.dat");
		ObjectInputStream obs = new ObjectInputStream(fis);
		HelloSerial hs = (HelloSerial)obs.readObject();
		hs.setVisible(true);
		// Obtenir le rectangle englobant les
		// composants Swing  incorporer au document
		Rectangle rect = hs.getContentPane().getBounds();
		
		pdfwriter = PdfWriter.getInstance(document,
				new FileOutputStream("SwingInPDF.pdf"));
		document.addAuthor("Fred");
		document.addCreator("Programmez!");
		document.addSubject("Magazine Programmez!");
		document.addTitle("Prsentation");
		document.open();
		
		Paragraph paragraph = new Paragraph(
				"Le magazine du dveloppement",
				FontFactory.getFont(FontFactory.TIMES_ITALIC, 24,
						Font.BOLDITALIC, new Color(0, 0, 0)));
		document.add(paragraph);
		
		PdfContentByte cb = pdfwriter.getDirectContent();
		PdfTemplate tp = cb.createTemplate(rect.width, rect.height);
		Graphics2D g2d;	
		g2d = tp.createGraphics(rect.width, rect.height);
		hs.print(g2d);
		g2d.dispose();
		cb.addTemplate(tp, 30, 500);
		
		paragraph = new Paragraph(
				"Visitez notre site et notre forum :-)",
				FontFactory.getFont(FontFactory.TIMES_ITALIC, 24,
						Font.BOLDITALIC, new Color(0, 0, 0)));
		paragraph.setSpacingBefore(260f);
		document.add(paragraph);
		hs.setVisible(false);
		hs.dispose();
		System.out.println("Gnration PDF termine");
	}
	catch (Exception e) {
		e.printStackTrace();
	}
	document.close();
	}
}
