// DemoCapture.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "DemoCapture.h"

#include <vfw.h>
#pragma comment(lib, "vfw32.lib")

#include <fstream>

using namespace std;

#error "definissez votre notre fichier de capture ici"
#define CAPTURE_FILE L"G:\\temp\\capture.avi"
#error "definissez votre fichier final de capture ici"
#define TARGET_CAPTURE L"G:\\temp\\ma_capture.avi"
#error "definissez votre fichier photo ici
#define TARGET_PHOTO L"G:\\temp\\ma_photo.bmp"

HWND capture_window;
const int id_webcam = 0;
void GetCaptureParms(const char*);

// La bonne approche pour une capture pendant un temps limit
// est l'utilisation d'un fonction de rappel comme celle ci-dessous
BOOL CALLBACK status_callback(HWND cw, int nID, LPCSTR lpsz )
{
	if(nID == IDS_CAP_BEGIN)
		Beep( 750, 300 );
	if(nID == IDS_CAP_END)
	{
		capFileSaveAs(capture_window, TARGET_CAPTURE); 
		Beep( 750, 300 );
	}
	return FALSE;
}

void InstallCallback()
{
	capSetCallbackOnStatus(capture_window, status_callback);
}

void DoCapture(HWND hwnd)
{
	if(capture_window == 0)
		return;

	::DeleteFile(CAPTURE_FILE);
	CAPTUREPARMS cp;
	BOOL result
	capCaptureGetSetup(capture_window,
		&cp, sizeof(cp));
	// demander une capture limite dans le temps
	cp.fLimitEnabled = TRUE ;
	// demander une capture pendant 5 secondes
	// compte tenu d'un "dlai" d'initialisation
	cp.wTimeLimit = 5 + 2;
	// Laisser les autres applications tourner
	cp.fYield  = TRUE;
	cp.fCaptureAudio = FALSE; // <-- INDISPENSABLE
	cp.AVStreamMaster = AVSTREAMMASTER_NONE;
	if(!capCaptureSetSetup(capture_window, &cp, sizeof(cp)))
	{
		::MessageBox(hwnd,
			L"Impossible de dfinir les paramtres de capture",
			L"Programmez!", MB_OK);
			return;
	}
	GetCaptureParms("captureparms-user.txt");
	// Dfinir le fichier tampon pour la capture)
	result = capFileSetCaptureFile(capture_window,  
		CAPTURE_FILE);
	if(!result)
	{
		::MessageBox(hwnd,
			L"Impossible de dfinir le fichier tampon de capture",
			L"Programmez!", MB_OK);
			return;
	}
	// Pr-allocation d'un fichier de 40 Mo
	if(!capFileAlloc(capture_window, 1024*1024*40)) 
	{
		::MessageBox(hwnd,
			L"Impossible de prdfinir la taille du tampon de capture",
			L"Programmez!", MB_OK);
			return;
	}
	
	if(!capCaptureSequence(capture_window))
	{
		::MessageBox(hwnd,
			L"Impossible de faire la capture",
			L"Programmez!", MB_OK);
	}
	// MAUVAISE approche
	//::Sleep(10000);
	//capFileSaveAs(capture_window, TARGET_CAPTURE); 
	//::MessageBox(hwnd,
	//		L"Fini",
	//		L"Programmez!", MB_OK);
}


void DoPhoto(HWND hwnd)
{
	if(!capGrabFrameNoStop(capture_window))
	{
		::MessageBox(hwnd,
			L"Impossible de faire la photo",
			L"Programmez!", MB_OK);
		return;
	}
	capFileSaveDIB(capture_window, TARGET_PHOTO);
	Beep(750, 300);
}

void OpenDlgVideoSource(HWND hwnd)
{
	if(capture_window == 0)
		return;

	CAPDRIVERCAPS cdc;
	capDriverGetCaps(capture_window,
		&cdc,
		sizeof(CAPDRIVERCAPS));
	if(!cdc.fHasDlgVideoSource)	
	{
		::MessageBox(hwnd, L"Dialogue VideoSource non support",
			L"Programmez!", MB_OK);
		return;
	}
	capDlgVideoSource(capture_window);
}

void OpenDlgVideoFormat(HWND hwnd)
{
	if(capture_window == 0)
		return;

	CAPDRIVERCAPS cdc;
	capDriverGetCaps(capture_window,
		&cdc,
		sizeof(CAPDRIVERCAPS));
	if(!cdc.fHasDlgVideoFormat)	
	{
		::MessageBox(hwnd, L"Dialogue VideoFormat non support",
			L"Programmez!", MB_OK);
		return;
	}
	capDlgVideoFormat(capture_window);
}

void OpenDlgVideoDisplay(HWND hwnd)
{
	if(capture_window == 0)
		return;

	CAPDRIVERCAPS cdc;
	capDriverGetCaps(capture_window,
		&cdc,
		sizeof(CAPDRIVERCAPS));
	if(!cdc.fHasDlgVideoDisplay)	
	{
		::MessageBox(hwnd, L"Dialogue VideoDisplay non support",
			L"Programmez!", MB_OK);
		return;
	}
	capDlgVideoDisplay(capture_window);
}

void OpenDlgVideoCompression(HWND hwnd)
{
	if(capture_window == 0)
		return;
	// On ne peut pas tester  
	// l'avance si ce dialogue est support :(
	BOOL result = capDlgVideoDisplay(capture_window);
	if(!result)
	{
		::MessageBox(hwnd, L"Problme, ou DialogueCompression non support",
			L"Programmez!", MB_OK);
	}
	GetCaptureParms("captureparms-user.txt");
}

void GetDriverName()
{
	WCHAR buffer[128];
	wofstream ofs("driver_name.txt", ios::out|ios::trunc);
	capDriverGetName(capture_window, buffer, sizeof(buffer)/sizeof(WCHAR));
	ofs << buffer << endl;
	capDriverGetVersion(capture_window, buffer, sizeof(buffer)/sizeof(WCHAR));
	ofs << buffer << endl;
}

void GetDriverCaps()
{
	CAPDRIVERCAPS cdc;
	capDriverGetCaps(capture_window,
		&cdc,
		sizeof(CAPDRIVERCAPS));
	ofstream ofs("driver_caps.txt", ios::out|ios::trunc);
	ofs << "wDeviceIndex: " << cdc.wDeviceIndex << endl;;
	ofs << "fHasOverlay: " << cdc.fHasOverlay << endl; 
	ofs << "fHasDlgVideoSource: " << cdc.fHasDlgVideoSource << endl;
	ofs << "fHasDlgVideoFormat: " << cdc.fHasDlgVideoFormat << endl; 
	ofs << "fHasDlgVideoDisplay: " << cdc.fHasDlgVideoDisplay << endl; 
	ofs << "fCaptureInitialized: " << cdc.fCaptureInitialized << endl;  
	ofs << "fDriverSuppliesPalettes: " << cdc.fDriverSuppliesPalettes << endl;
}

void GetCaptureParms(const char* fichier)
{
	CAPTUREPARMS cp;
	capCaptureGetSetup(capture_window,
		&cp, sizeof(CAPTUREPARMS));
	ofstream ofs(fichier, ios::out|ios::trunc);
	
	ofs << "dwRequestMicroSecPerFrame: " << cp.dwRequestMicroSecPerFrame << endl; 
	ofs << "fMakeUserHitOKToCapture: " << cp.fMakeUserHitOKToCapture << endl;
	ofs << "wPercentDropForError: " << cp.wPercentDropForError << endl; 
	ofs << "fYield: " << cp.fYield << endl;
	ofs << "dwIndexSize;: " << cp.dwIndexSize << endl;
	ofs << "wChunkGranularity: " << cp.wChunkGranularity << endl;
	ofs << "wNumVideoRequested: " << cp.wNumVideoRequested << endl; 
	ofs << "fCaptureAudio: " << cp.fCaptureAudio << endl;
	ofs << "wNumAudioRequested: " << cp.wNumAudioRequested << endl; 
	ofs << "vKeyAbort: " << cp.vKeyAbort << endl;
	ofs << "fAbortLeftMouse: " << cp.fAbortRightMouse << endl; 
	ofs << "fAbortRightMouse: " << cp.fAbortRightMouse << endl; 
	ofs << "fLimitEnabled: " << cp.fLimitEnabled << endl;
	ofs << "wTimeLimit: " << cp.wTimeLimit << endl;
	ofs << "fMCIControl: " << cp.fMCIControl << endl; 
	ofs << "fStepMCIDevice: " << cp.fStepMCIDevice << endl;
	ofs << "dwMCIStartTime: " << cp.dwMCIStartTime << endl; 
	ofs << "dwMCIStopTime: " << cp.dwMCIStopTime << endl; 
	ofs << "fStepCaptureAt2x: " << cp.fStepCaptureAt2x << endl; 
	ofs << "wStepCaptureAverageFrames: " << cp.wStepCaptureAverageFrames << endl;
	ofs << "dwAudioBufferSize: " << cp.dwAudioBufferSize << endl; 
	ofs << "AVStreamMaster: " << cp.AVStreamMaster << endl;
}

void GetInfos()
{
	GetDriverName();
	GetDriverCaps();
	GetCaptureParms("captureparms-default.txt");
}

BOOL CreateCaptureWindow(HWND hwnd)
{
	capture_window = ::capCreateCaptureWindow ( L"Ma Capture Window", 
			WS_CHILD | WS_VISIBLE , 0, 0, 640, 480,
					hwnd, 0);
	return capture_window != 0 ? TRUE : FALSE;
}

BOOL MakeConnexion()
{
	return static_cast<BOOL>(::SendMessage(capture_window,
		WM_CAP_DRIVER_CONNECT,
		static_cast<WPARAM>(id_webcam),
		0L));
}

BOOL CreatePreview()
{
	if(!capPreviewRate(capture_window, 66))
		return FALSE;
	// Eventuellement adapter la fentre
	//  la preview avec capPreviewScale
	capPreviewScale(capture_window, TRUE);
	return capPreview(capture_window, TRUE);
}

void DoPreview(HWND hwnd)
{
	BOOL result;

	result = CreateCaptureWindow(hwnd);
	if(!result)
	{
		::MessageBox(hwnd, L"Impossible de crer la fentre de capture",
			L"Programmez!", MB_OK);
		return;
	}

	result = MakeConnexion();
	if(!result)
	{
		::MessageBox(hwnd, L"Impossible d'tablir la connexion",
			L"Programmez!", MB_OK);
		return;
	}

	result = CreatePreview();
	if(!result)
	{
		::MessageBox(hwnd, L"Impossible d'tablir la prvisualisation",
			L"Programmez!", MB_OK);
		return;
	}
	
	GetInfos();
	InstallCallback(); // Attention  WM_DESTROY
}

#define MAX_LOADSTRING 100

// Global Variables:
HINSTANCE hInst;								// current instance
TCHAR szTitle[MAX_LOADSTRING];					// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];			// the main window class name

// Forward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

 	// TODO: Place code here.
	MSG msg;
	HACCEL hAccelTable;

	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_DEMOCAPTURE, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow))
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_DEMOCAPTURE));

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int) msg.wParam;
}



//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage are only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_DEMOCAPTURE));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_DEMOCAPTURE);
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassEx(&wcex);
}

//
//   FUNCTION: InitInstance(HINSTANCE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // Store instance handle in our global variable

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

//
//  FUNCTION: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	switch (message)
	{
	case WM_SHOWWINDOW:
		DoPreview(hWnd);
		break;
	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		// Parse the menu selections:
		switch (wmId)
		{
		case IDM_ABOUT:
			DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
			break;
		case ID_FILE_CAPDLGVIDEOSOURCE:
			OpenDlgVideoSource(hWnd);
			break;
		case ID_FILE_CAPDLGVIDEOFORMAT:
			OpenDlgVideoFormat(hWnd);
			break;
		case ID_FILE_CAPDLGVIDEODISPLAY:
			OpenDlgVideoDisplay(hWnd);
			break;
		case ID_FILE_CAPDLGVIDEOCOMPRESSION:
			OpenDlgVideoCompression (hWnd);
			break;
		case ID_FILE_CAPTURE:
			DoCapture(hWnd);
			break;
		case ID_FILE_PHOTO:
			DoPhoto(hWnd);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);
		// TODO: Add any drawing code here...
		EndPaint(hWnd, &ps);
		break;
	
	// Important ici
	case WM_CLOSE:
		if(capture_window != 0)
			capSetCallbackOnVideoStream(capture_window, NULL);
		break;
	
	case WM_DESTROY:
		if(capture_window != 0)
			capSetCallbackOnVideoStream(capture_window, NULL);
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// Message handler for about box.
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}
