﻿using System;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Input;
using System.Data.Linq;

namespace PhoneClassLibrary1
{
    public static class Referentiel
    {
        public static void Reset()
        {
            _pays = null;
            _regions = null;
            _couleurs = null;
            _typesGardes = null;
        }
        private static ObservableCollection<Pays> _pays = null;
        public static ObservableCollection<Pays> Pays
        {
            get
            {
                if (_pays == null)
                {
                    _pays = new ObservableCollection<Pays>();
                    try
                    {
                        using (WineDatacontext db = new WineDatacontext())
                        {
                            DataLoadOptions options = new DataLoadOptions();
                            options.LoadWith<Pays>(p => p.Regions);
                            options.LoadWith<Region>(r => r.Appellations);
                            options.LoadWith<Appellation>(a => a.SousRegion);
                            options.LoadWith<Appellation>(a => a.TypeAppellation);
                            db.LoadOptions = options;
                            var list = from Pays p in db.Pays
                                       orderby p.Nom
                                       select p;
                            foreach (var p in list)
                            {
                                _pays.Add(p);
                            }
                        }
                    }
                    catch (Exception ex)
                    {
                        _pays.Add(new Pays { Nom = ex.Message });
                    }
                }
                return _pays;
            }
        }

        private static ObservableCollection<Region> _regions = null;
        public static ObservableCollection<Region> Regions
        {
            get
            {
                if (_regions == null)
                {
                    _regions = new ObservableCollection<Region>();
                    try
                    {
                        using (WineDatacontext db = new WineDatacontext())
                        {
                            DataLoadOptions options = new DataLoadOptions();
                            options.LoadWith<Region>(r => r.Appellations);
                            db.LoadOptions = options;
                            var list = from Region r in db.Regions
                                       orderby r.Nom
                                       select r;
                            foreach (var r in list)
                            {
                                _regions.Add(r);
                            }
                        }
                    }
                    catch (Exception ex)
                    {
                        _regions.Add(new Region { Nom = ex.Message });
                    }
                }
                return _regions;
            }
        }

        private static ObservableCollection<TypeGarde> _typesGardes = null;
        public static ObservableCollection<TypeGarde> TypesGardes
        {
            get
            {
                if (_typesGardes == null)
                {
                    _typesGardes = new ObservableCollection<TypeGarde>();
                    try
                    {
                        using (WineDatacontext db = new WineDatacontext())
                        {
                            var list = from TypeGarde t in db.TypesGardes
                                       orderby t.Ordre
                                       select t;
                            foreach (var t in list)
                            {
                                _typesGardes.Add(t);
                            }
                        }
                    }
                    catch (Exception ex)
                    {
                        _typesGardes.Add(new TypeGarde{ Libelle = ex.Message });
                    }
                }
                return _typesGardes;
            }
        }
        private static ObservableCollection<Couleur> _couleurs = null;
        public static ObservableCollection<Couleur> Couleurs
        {
            get
            {
                if (_couleurs == null)
                {
                    _couleurs = new ObservableCollection<Couleur>();
                    try
                    {
                        using (WineDatacontext db = new WineDatacontext())
                        {
                            var list = from Couleur c in db.Couleurs
                                       orderby c.Nom
                                       select c;
                            foreach (var c in list)
                            {
                                _couleurs.Add(c);
                            }
                        }
                    }
                    catch (Exception ex)
                    {
                        _couleurs.Add(new Couleur { Nom = ex.Message });
                    }
                }
                return _couleurs;
            }
        }
    }
}
