﻿#define VERSION_2
using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Data.Linq;
using System.Data.Linq.Mapping;
using System.ComponentModel;
using Microsoft.Phone.Data.Linq.Mapping;
namespace PhoneClassLibrary1
{
public class WineDatacontext : DataContext
{
    private const string DefaultConnectionString = "Data Source=isostore:/BaseVins.sdf";

#if VERSION_2
    public const int SchemaVersion = 2;
#else
    public const int SchemaVersion = 1;
#endif

    public WineDatacontext(string connectionString = null) : base(connectionString ?? DefaultConnectionString) { }

    public Table<Pays> Pays;
    public Table<Couleur> Couleurs;
    public Table<TypeAppellation> TypesAppellation;
    public Table<Region> Regions;
    public Table<SousRegion> SousRegions;
    public Table<TypeGarde> TypesGardes;
    public Table<Appellation> Appellations;
    public Table<Vin> Vins;
    public Table<Entree> Entrees;
    public Table<Sortie> Sorties;

}

    [Table]
    public class Pays : BindableObject
    {
        private int _id;
        [Column(IsPrimaryKey=true, IsDbGenerated=true, DbType="INT NOT NULL Identity", AutoSync=AutoSync.OnInsert)]
        public int Id
        {
            get { return _id; }
            set
            {
                if (_id != value)
                {
                    _id = value;
                    OnPropertyChanged("Id");
                }
            }
        }

        private string _nom;
        [Column(IsPrimaryKey = false, DbType = "NVARCHAR(50) NOT NULL")]
        public string Nom
        {
            get { return _nom; }
            set
            {
                if (_nom != value)
                {
                    _nom = value;
                    OnPropertyChanged("Nom");
                }
            }
        }

        public override string ToString()
        {
            return Nom;
        }

        private EntitySet<Region> _regions;
        [Association(Storage = "_regions", OtherKey = "IdPays", ThisKey = "Id")]
        public EntitySet<Region> Regions
        {
            get { return this._regions; }
            set
            {
                this._regions.Assign(value);
                OnPropertyChanged("Regions");
            }
        }
        public Pays()
        {
            _regions = new EntitySet<Region>(
                new Action<Region>(this.attach_Region),
                new Action<Region>(this.detach_Region)
                );
        }

        // Called during an add operation
        private void attach_Region(Region Region)
        {
            Region.Pays = this;
        }

        // Called during a remove operation
        private void detach_Region(Region Region)
        {
            Region.Pays = null;
        }
    }
    [Table]
    public class Couleur : BindableObject
    {

        private int _id;
        [Column(IsPrimaryKey=true, IsDbGenerated=true, DbType="INT NOT NULL Identity", AutoSync=AutoSync.OnInsert)]
        public int Id
        {
            get { return _id; }
            set
            {
                if (_id != value)
                {
                    _id = value;
                    OnPropertyChanged("Id");
                }
            }
        }

        private string _nom;
        [Column(IsPrimaryKey = false, DbType = "NVARCHAR(20) NOT NULL")]
        public string Nom
        {
            get { return _nom; }
            set
            {
                if (_nom != value)
                {
                    _nom = value;
                    OnPropertyChanged("Nom");
                }
            }
        }
        public override string ToString()
        {
            return Nom;
        }

    }
    [Table]
    public class TypeGarde : BindableObject
    {
        private int _id;
        [Column(IsPrimaryKey=true, IsDbGenerated=true, DbType="INT NOT NULL Identity", AutoSync=AutoSync.OnInsert)]
        public int Id
        {
            get { return _id; }
            set
            {
                if (_id != value)
                {
                    _id = value;
                    OnPropertyChanged("Id");
                }
            }
        }

        private int _ordre;
        [Column(IsPrimaryKey=false, DbType="INT NOT NULL")]
        public int Ordre
        {
            get { return _ordre; }
            set
            {
                if (_ordre != value)
                {
                    _ordre = value;
                    OnPropertyChanged("Ordre");
                }
            }
        }

        private string _libelle;
        [Column(IsPrimaryKey = false, DbType = "NVARCHAR(50) NOT NULL")]
        public string Libelle
        {
            get { return _libelle; }
            set
            {
                if (_libelle != value)
                {
                    _libelle = value;
                    OnPropertyChanged("Libelle");
                }
            }
        }
        public override string ToString()
        {
            return Libelle;
        }
    }
    [Table]
    public class TypeAppellation : BindableObject
    {
        private int _id;
        [Column(IsPrimaryKey=true, IsDbGenerated=true, DbType="INT NOT NULL Identity", AutoSync=AutoSync.OnInsert)]
        public int Id
        {
            get { return _id; }
            set
            {
                if (_id != value)
                {
                    _id = value;
                    OnPropertyChanged("Id");
                }
            }
        }

        private string _nom;
        [Column(IsPrimaryKey = false, DbType = "NVARCHAR(100) NOT NULL")]
        public string Nom
        {
            get { return _nom; }
            set
            {
                if (_nom != value)
                {
                    _nom = value;
                    OnPropertyChanged("Nom");
                }
            }
        }

        private int _ordre;
        [Column(IsPrimaryKey=false, DbType="INT NOT NULL")]
        public int Ordre
        {
            get { return _ordre; }
            set
            {
                if (_ordre != value)
                {
                    _ordre = value;
                    OnPropertyChanged("Ordre");
                }
            }
        }

        private string _abreviation;
        [Column(IsPrimaryKey = false, DbType = "NVARCHAR(10) NOT NULL")]
        public string Abreviation
        {
            get { return _abreviation; }
            set
            {
                if (_abreviation != value)
                {
                    _abreviation = value;
                    OnPropertyChanged("Abreviation");
                }
            }
        }
        public override string ToString()
        {
            return Nom;
        }
    }
    [Table]
    public class Region : BindableObject
    {
        private int _id;
        [Column(IsPrimaryKey=true, IsDbGenerated=true, DbType="INT NOT NULL Identity", AutoSync=AutoSync.OnInsert)]
        public int Id
        {
            get { return _id; }
            set
            {
                if (_id != value)
                {
                    _id = value;
                    OnPropertyChanged("Id");
                }
            }
        }

        private string _nom;
        [Column(IsPrimaryKey = false, DbType = "NVARCHAR(100) NOT NULL")]
        public string Nom
        {
            get { return _nom; }
            set
            {
                if (_nom != value)
                {
                    _nom = value;
                    OnPropertyChanged("Nom");
                }
            }
        }

        [Column(IsPrimaryKey = false, DbType = "INT NOT NULL")]
        internal int IdPays { get; set; }

        private EntityRef<Pays> _pays;
        [Association(Storage="_pays", ThisKey="IdPays", OtherKey="Id", IsForeignKey=true)]
        public Pays Pays
        {
            get { return this._pays.Entity; }
            set
            {
                if (this._pays.Entity != value)
                {
                    this._pays.Entity = value;
                    if (value != null) IdPays = value.Id;
                    OnPropertyChanged("Pays");
                }
            }
        }

        private EntitySet<SousRegion> _sousRegions;
        [Association(Storage="_sousRegions", OtherKey = "IdRegion", ThisKey="Id")]
        public EntitySet<SousRegion> SousRegions
        {
            get { return this._sousRegions; }
            set {
                this._sousRegions.Assign(value);
                OnPropertyChanged("SousRegions");
            }
        }

        private EntitySet<Appellation> _appellations;
        [Association(Storage = "_appellations", OtherKey = "IdRegion", ThisKey = "Id")]
        public EntitySet<Appellation> Appellations
        {
            get { return this._appellations; }
            set
            {
                this._appellations.Assign(value);
                OnPropertyChanged("Appellations");
            }
        }

        // Assign handlers for the add and remove operations, respectively.
        public Region()
        {
            _sousRegions = new EntitySet<SousRegion>(
                new Action<SousRegion>(this.attach_SousRegion),
                new Action<SousRegion>(this.detach_SousRegion)
                );
            _appellations = new EntitySet<Appellation>(
                new Action<Appellation>(this.attach_Appellation),
                new Action<Appellation>(this.detach_Appellation)
                );
        }

        // Called during an add operation
        private void attach_SousRegion(SousRegion sousRegion)
        {
            sousRegion.Region = this;
        }

        // Called during a remove operation
        private void detach_SousRegion(SousRegion sousRegion)
        {
            sousRegion.Region = null;
        }
        // Called during an add operation
        private void attach_Appellation(Appellation appellation)
        {
            appellation.Region = this;
        }

        // Called during a remove operation
        private void detach_Appellation(Appellation appellation)
        {
            appellation.Region = null;
        }
        public override string ToString()
        {
            return Nom;
        }
    }
    [Table]
    public class SousRegion : BindableObject
    {
        private int _id;
        [Column(IsPrimaryKey=true, IsDbGenerated=true, DbType="INT NOT NULL Identity", AutoSync=AutoSync.OnInsert)]
        public int Id
        {
            get { return _id; }
            set
            {
                if (_id != value)
                {
                    _id = value;
                    OnPropertyChanged("Id");
                }
            }
        }

        private string _nom;
        [Column(IsPrimaryKey = false, DbType = "NVARCHAR(100) NOT NULL")]
        public string Nom
        {
            get { return _nom; }
            set
            {
                if (_nom != value)
                {
                    _nom = value;
                    OnPropertyChanged("Nom");
                }
            }
        }

        [Column(IsPrimaryKey = false, DbType = "INT NOT NULL")]
        internal int IdRegion { get; set; }

        private EntityRef<Region> _region;
        [Association(Storage="_region", ThisKey="IdRegion", OtherKey="Id", IsForeignKey=true)]
        public Region Region
        {
            get { return this._region.Entity; }
            set
            {
                if (this._region.Entity != value)
                {
                    this._region.Entity = value;
                    if (value != null) IdRegion = value.Id;
                    OnPropertyChanged("Region");
                }
            }
        }

        public override string ToString()
        {
            return Nom;
        }
    }
    [Table]
    [Index(Columns="Nom", IsUnique=true, Name="IX_Appellation_Nom")]
    public class Appellation : BindableObject
    {
        private int _id;
        [Column(IsPrimaryKey=true, IsDbGenerated=true, DbType="INT NOT NULL Identity", AutoSync=AutoSync.OnInsert)]
        public int Id
        {
            get { return _id; }
            set
            {
                if (_id != value)
                {
                    _id = value;
                    OnPropertyChanged("Id");
                }
            }
        }

        private string _nom;
        [Column(IsPrimaryKey = false, DbType = "NVARCHAR(100) NOT NULL")]
        public string Nom
        {
            get { return _nom; }
            set
            {
                if (_nom != value)
                {
                    _nom = value;
                    OnPropertyChanged("Nom");
                }
            }
        }

        [Column(IsPrimaryKey = false, DbType = "INT NOT NULL")]
        internal int IdRegion { get; set; }

        private EntityRef<Region> _region;
        [Association(Storage = "_region", ThisKey = "IdRegion", OtherKey = "Id", IsForeignKey = true)]
        public Region Region
        {
            get { return this._region.Entity; }
            set
            {
                if (this._region.Entity != value)
                {
                    this._region.Entity = value;
                    if (value != null) IdRegion = value.Id;
                    OnPropertyChanged("Region");
                }
            }
        }

        [Column(IsPrimaryKey=false, DbType="INT")]
        public int? IdSousRegion { get;set; }

        private EntityRef<SousRegion> _sousRegion;
        [Association(Storage = "_sousRegion", ThisKey = "IdSousRegion", OtherKey = "Id", IsForeignKey = true)]
        public SousRegion SousRegion
        {
            get { return this._sousRegion.Entity; }
            set
            {
                if (this._sousRegion.Entity != value)
                {
                    this._sousRegion.Entity = value;
                    if (value != null) IdSousRegion = value.Id;
                    OnPropertyChanged("SousRegion");
                }
            }
        }

        [Column(IsPrimaryKey = false, DbType = "INT NOT NULL")]
        internal int IdTypeAppellation { get; set; }

        private EntityRef<TypeAppellation> _typeAppellation;
        [Association(Storage = "_typeAppellation", ThisKey = "IdTypeAppellation", OtherKey = "Id", IsForeignKey = true)]
        public TypeAppellation TypeAppellation
        {
            get { return this._typeAppellation.Entity; }
            set
            {
                if (this._typeAppellation.Entity != value)
                {
                    this._typeAppellation.Entity = value;
                    if (value != null) IdTypeAppellation = value.Id;
                    OnPropertyChanged("TypeAppellation");
                }
            }
        }
        public override string ToString()
        {
            return Nom;
        }
    }
    [Table]
    public class Vin : BindableObject
    {
        private int _id;
        [Column(IsPrimaryKey=true, IsDbGenerated=true, DbType="INT NOT NULL Identity", AutoSync=AutoSync.OnInsert)]
        public int Id
        {
            get { return _id; }
            set
            {
                if (_id != value)
                {
                    _id = value;
                    OnPropertyChanged("Id");
                }
            }
        }

        private string _nom;
        [Column(IsPrimaryKey = false, DbType = "NVARCHAR(100) NOT NULL")]
        public string Nom
        {
            get { return _nom; }
            set
            {
                if (_nom != value)
                {
                    _nom = value;
                    OnPropertyChanged("Nom");
                }
            }
        }

        [Column(IsPrimaryKey = false, DbType = "INT NOT NULL")]
        internal int IdAppellation { get; set; }

        private EntityRef<Appellation> _appellation;
        [Association(Storage = "_appellation", ThisKey = "IdAppellation", OtherKey = "Id", IsForeignKey = true, DeleteRule = "NO ACTION")]
        public Appellation Appellation
        {
            get { return this._appellation.Entity; }
            set {
                if (_appellation.Entity != value)
                {
                    this._appellation.Entity = value;
                    if (value != null) IdAppellation = value.Id;
                    OnPropertyChanged("Appellation");
                }
            }
        }

        [Column(IsPrimaryKey = false, DbType = "INT NOT NULL")]
        internal int IdCouleur { get; set; }

        private EntityRef<Couleur> _couleur;
        [Association(Storage = "_couleur", ThisKey = "IdCouleur", OtherKey = "Id", IsForeignKey = true)]
        public Couleur Couleur
        {
            get { return this._couleur.Entity; }
            set {
                if (this._couleur.Entity != value)
                {
                    this._couleur.Entity = value;
                    if (value != null) IdCouleur = value.Id;
                    OnPropertyChanged("Couleur");
                }
            }
        }

        private string _commentaire;
        [Column(IsPrimaryKey=false, DbType="NVARCHAR(200)")]
        public string Commentaire
        {
            get { return _commentaire; }
            set
            {
                if (_commentaire != value)
                {
                    _commentaire = value;
                    OnPropertyChanged("Commentaire");
                }
            }
        }

        private int _nbBouteilles;
        [Column(IsPrimaryKey=false, DbType="INT NOT NULL")]
        public int NbBouteilles
        {
            get { return _nbBouteilles; }
            set
            {
                if (_nbBouteilles != value)
                {
                    _nbBouteilles = value;
                    OnPropertyChanged("NbBouteilles");
                }
            }
        }

        private int _millesime;
        [Column(IsPrimaryKey=false, DbType="INT NOT NULL")]
        public int Millesime
        {
            get { return _millesime; }
            set
            {
                if (_millesime != value)
                {
                    _millesime= value;
                    OnPropertyChanged("Millesime");
                }
            }
        }

        [Column(IsPrimaryKey = false, DbType = "INT NOT NULL")]
        internal int IdTypeGarde { get; set; }

        private EntityRef<TypeGarde> _typeGarde;
        [Association(Storage = "_typeGarde", ThisKey = "IdTypeGarde", OtherKey = "Id", IsForeignKey = true)]
        public TypeGarde TypeGarde
        {
            get { return this._typeGarde.Entity; }
            set {
                if (this._typeGarde.Entity != value)
                {
                    this._typeGarde.Entity = value;
                    if (value != null) IdTypeGarde = value.Id;
                    OnPropertyChanged("TypeGarde");
                }
            }
        }
    
        private EntitySet<Entree> _entrees;
        [Association(Storage="_entrees", OtherKey = "IdVin", ThisKey="Id")]
        public EntitySet<Entree> Entrees
        {
            get { return this._entrees; }
            set {
                this._entrees.Assign(value);
                OnPropertyChanged("Entrees");
            }
        }

        private EntitySet<Sortie> _sorties;
        [Association(Storage="_sorties", OtherKey = "IdVin", ThisKey="Id")]
        public EntitySet<Sortie> Sorties
        {
            get { return this._sorties; }
            set {
                this._sorties.Assign(value);
                OnPropertyChanged("Sorties");
            }
        }
        // Assign handlers for the add and remove operations, respectively.
        public Vin()
        {
            if (BindableObject.IsInDesignMode)
            {
                Nom = "Grand vin de Léoville Las Cases";
                NbBouteilles = 6;
                Millesime = 2000;
                Appellation = new Appellation { Nom = "Saint Julien" };
            }
            _entrees = new EntitySet<Entree>(
                new Action<Entree>(this.attach_Entree),
                new Action<Entree>(this.detach_Entree)
                );
            _sorties = new EntitySet<Sortie>(
                new Action<Sortie>(this.attach_Sortie),
                new Action<Sortie>(this.detach_Sortie)
                );
        }

        // Called during an add operation
        private void attach_Entree(Entree entree)
        {
            entree.Vin = this;
        }

        // Called during a remove operation
        private void detach_Entree(Entree entree)
        {
            entree.Vin = null;
        }

        // Called during an add operation
        private void attach_Sortie(Sortie sortie)
        {
            sortie.Vin = this;
        }

        // Called during a remove operation
        private void detach_Sortie(Sortie sortie)
        {
            sortie.Vin = null;
        }
        public override string ToString()
        {
            return Nom;
        }
    }
    [Table]
    public class Entree : BindableObject
    {

        private int _id;
        [Column(IsPrimaryKey=true, IsDbGenerated=true, DbType="INT NOT NULL Identity", AutoSync=AutoSync.OnInsert)]
        public int Id
        {
            get { return _id; }
            set
            {
                if (_id != value)
                {
                    _id = value;
                    OnPropertyChanged("Id");
                }
            }
        }

        private DateTime _quand;
        [Column(IsPrimaryKey = false, DbType = "DATETIME NOT NULL")]
        public DateTime Quand
        {
            get { return _quand; }
            set
            {
                if (_quand != value)
                {
                    _quand = value;
                    OnPropertyChanged("Quand");
                }
            }
        }

        private string _lieuAchat;
        [Column(IsPrimaryKey=false, DbType="NVARCHAR(100)")]
        public string LieuAchat
        {
            get { return _lieuAchat; }
            set
            {
                if (_lieuAchat != value)
                {
                    _lieuAchat = value;
                    OnPropertyChanged("LieuAchat");
                }
            }
        }

        private DateTime _nb;
        [Column(IsPrimaryKey=false, DbType="INT NOT NULL")]
        public DateTime Nb
        {
            get { return _nb; }
            set
            {
                if (_nb != value)
                {
                    _nb= value;
                    OnPropertyChanged("Nb");
                }
            }
        }

        [Column(IsPrimaryKey = false, DbType = "INT NOT NULL")]
        internal int IdVin { get; set; }

        private EntityRef<Vin> _vin;
        [Association(Storage = "_vin", ThisKey = "IdVin", OtherKey = "Id", IsForeignKey = true)]
        public Vin Vin
        {
            get { return this._vin.Entity; }
            set {
                if (this._vin.Entity != value)
                {
                    this._vin.Entity = value;
                    if (value != null) IdVin = value.Id;
                    OnPropertyChanged("Vin");
                }
            }
        }
    }
    [Table]
    public class Sortie : BindableObject
    {

        private int _id;
        [Column(IsPrimaryKey=true, IsDbGenerated=true, DbType="INT NOT NULL Identity", AutoSync=AutoSync.OnInsert)]
        public int Id
        {
            get { return _id; }
            set
            {
                if (_id != value)
                {
                    _id = value;
                    OnPropertyChanged("Id");
                }
            }
        }

        private DateTime _quand;
        [Column(IsPrimaryKey = false, DbType = "DATETIME NOT NULL")]
        public DateTime Quand
        {
            get { return _quand; }
            set
            {
                if (_quand != value)
                {
                    _quand = value;
                    OnPropertyChanged("Quand");
                }
            }
        }

#if VERSION_2
        private string _commentaire;
        [Column(IsPrimaryKey=false, DbType="NVARCHAR(200)")]
        public string Commentaire
        {
            get { return _commentaire; }
            set
            {
                if (_commentaire != value)
                {
                    _commentaire = value;
                    OnPropertyChanged("Commentaire");
                }
            }
        }
#endif

        private DateTime _nb;
        [Column(IsPrimaryKey=false, DbType="INT NOT NULL")]
        public DateTime Nb
        {
            get { return _nb; }
            set
            {
                if (_nb != value)
                {
                    _nb= value;
                    OnPropertyChanged("Nb");
                }
            }
        }

        [Column(IsPrimaryKey = false, DbType = "INT NOT NULL")]
        internal int IdVin { get; set; }

        private EntityRef<Vin> _vin;
        [Association(Storage = "_vin", ThisKey = "IdVin", OtherKey = "Id", IsForeignKey = true)]
        public Vin Vin
        {
            get { return this._vin.Entity; }
            set {
                if (this._vin.Entity != value)
                {
                    this._vin.Entity = value;
                    if (value != null) IdVin = value.Id;
                    OnPropertyChanged("Vin");
                }
            }
        }
    }
}