﻿using System.ComponentModel;
using System.Windows;

namespace PhoneClassLibrary1
{
    public class BindableObject : INotifyPropertyChanged
    {

        protected void OnPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }
        public event PropertyChangedEventHandler PropertyChanged;


#if DEBUG
        #region Gestion du Design Mode
        private static bool? _isInDesignMode;

        /// <summary>
        /// Retourne true si le code s'exécute dans un Designer
        /// </summary>
        public static bool IsInDesignMode
        {
            get
            {
                if (!_isInDesignMode.HasValue)
                {
#if SILVERLIGHT 
                    _isInDesignMode = DesignerProperties.IsInDesignTool; 
#else
                    var prop = DesignerProperties.IsInDesignModeProperty;
                    _isInDesignMode = (bool)DependencyPropertyDescriptor.FromProperty(prop, typeof(FrameworkElement)).Metadata.DefaultValue;
#endif
                }
                return _isInDesignMode.Value;
            }
        }
        #endregion
#endif

    }
}
