﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Windows.Data;

namespace PhoneClassLibrary1
{
    public static class Helpers
    {
        public static bool SafeValue(object value, bool defaultValue)
        {
            if ((value == null) || (value.GetType() != typeof(bool)))
            {
                return defaultValue;
            }
            else
            {
                return (bool)value;
            }
        }
        public static int SafeValue(object value, int defaultValue)
        {
            if (value == null)
            {
                return defaultValue;
            }
            else if (value.GetType() == typeof(int))
            {
                return (int)value;
            }
            else if (value.GetType() == typeof(string))
            {
                return int.Parse(value as string);
            }
            else
            {
                return defaultValue;
            }
        }
    }
    public class Bool2VisiblityConverter : IValueConverter
    {

        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            return Helpers.SafeValue(value, false) ? Visibility.Visible : Visibility.Collapsed;
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            return DependencyProperty.UnsetValue;
        }
    }
    public class LargeurConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            int nb = Helpers.SafeValue(value, 0);
            int largeur = Helpers.SafeValue(parameter, 0);
            return nb * largeur;
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            return DependencyProperty.UnsetValue;
        }
    }
    public class ViewPortGenerator : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            int nb = Helpers.SafeValue(value, 0);
            double w = (nb > 0) ? (1.0 / (double)nb) : 1.0;
            return new Rect(0, 0, w, 1);
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            return DependencyProperty.UnsetValue;
        }
    }
}
