﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace PhoneClassLibrary1
{

    public class SingleValueEventArgs<T> : EventArgs
    {
        private T _value;
        public T Value { get { return _value; } }
        public SingleValueEventArgs(T value)
        {
            this._value = value;
        }
    }
    public static class Eventing
    {
        public static event EventHandler NouveauVin;
        public static event EventHandler<SingleValueEventArgs<Vin>> VinSaved;
        public static event EventHandler CaveReset;


        public static void OnNouveauVin()
        {
            if (NouveauVin != null) NouveauVin(null, null);
        }
        public static void OnVinSaved(Vin vin)
        {
            if (VinSaved != null) VinSaved(null, new SingleValueEventArgs<Vin>(vin));
        }

        public static void OnCaveReset()
        {
            if (CaveReset != null) CaveReset(null, null);
        }
    }
}
