﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Input;
using System.Windows;
using System.Windows.Controls;

namespace PhoneClassLibrary1
{
    public class RelayCommand : ICommand
    {
        private readonly Action _handlerNoParam;
        private readonly Action<object> _handler;
        private bool _isEnabled;

        public RelayCommand(Action handlerNoParam)
        {
            _handlerNoParam = handlerNoParam;
            _isEnabled = true;
        }
        public RelayCommand(Action<object> handler)
        {
            _handler = handler;
            _isEnabled = true;
        }

        public bool IsEnabled
        {
            get { return _isEnabled; }
            set
            {
                if (value != _isEnabled)
                {
                    _isEnabled = value;
                    if (CanExecuteChanged != null)
                    {
                        CanExecuteChanged(this, EventArgs.Empty);
                    }
                }
            }
        }

        public bool CanExecute(object parameter)
        {
            return IsEnabled;
        }

        public event EventHandler CanExecuteChanged;

        public virtual void Execute(object parameter)
        {
            if (_handlerNoParam != null)
            {
                _handlerNoParam();
            }
            else if (_handler != null)
            {
                _handler(parameter);
            }
        }

        public void ExecuteHandler(object sender, RoutedEventArgs e)
        {
            Execute(null);
        }

    }
}
