﻿using System;
using System.Collections.ObjectModel;
using System.Data.Linq;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Input;
using System.Text;

namespace PhoneClassLibrary1
{
    public class VerboseCommand : RelayCommand
    {
        public VerboseCommand(Action handlerNoParam) : base(handlerNoParam)
        {
        }
        public VerboseCommand(Action<object> handler) : base(handler)
        {
        }

        public override void Execute(object parameter)
        {
            try
            {
                base.Execute(parameter);
                MessageBox.Show("ok");
            }
            catch (Exception ex)
            {
                HandleException(ex);
            }
        }

        public void HandleException(Exception ex)
        {
            StringBuilder builder = new StringBuilder();
            while (ex != null)
            {
                builder.AppendLine(ex.Message);
                ex = ex.InnerException;
            }
            MessageBox.Show(builder.ToString());
        }
    }
}
