﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.ObjectModel;
using System.Data.Linq;
using System.Linq;

namespace PhoneClassLibrary1
{
    public class VinsParRegion
    {
        public Region Region { get; set; }
        public ObservableCollection<Vin> Vins { get; set; }

#if DEBUG
        // Juste pour le design time
        public VinsParRegion()
        {
            if (BindableObject.IsInDesignMode)
            {
                this.Region = new Region { Nom = "Bordeaux" };
                this.Vins = new ObservableCollection<Vin>();
                this.Vins.Add(new Vin());
            }
        }
#endif
        public VinsParRegion(Region region)
        {
            this.Region = region;
            this.Vins = new ObservableCollection<Vin>();
        }
        public static ObservableCollection<VinsParRegion> ChargerTout()
        {
            ObservableCollection<VinsParRegion> ret = new ObservableCollection<VinsParRegion>();
            VinsParRegion regionCourante = null;
            using (WineDatacontext db = new WineDatacontext())
            {
                DataLoadOptions options = new DataLoadOptions();
                options.LoadWith<Vin>(v => v.Appellation);
                options.LoadWith<Appellation>(a => a.Region);
                db.LoadOptions = options;
                var list = from Vin v in db.Vins orderby v.Appellation.Region.Nom
                           select v;
                foreach (var v in list)
                {
                    if ((regionCourante == null) || (regionCourante.Region.Id != v.Appellation.IdRegion))
                    {
                        regionCourante = new VinsParRegion(v.Appellation.Region);
                        ret.Add(regionCourante);
                    }
                    regionCourante.Vins.Add(v);
                }
            }
            return ret;
        }
    }
}
