﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using PhoneClassLibrary1;
using System.Collections.Generic;
using System.Xml.Linq;
using System.IO;
using System.Collections.ObjectModel;
using Microsoft.Phone.Data.Linq;

namespace PivotApp1
{
    public class InitDatabaseViewModel : BindableObject
    {
        public ICommand CreateNewCommand { get; private set; }
        public ICommand FillDataCommand { get; private set; }
        public ICommand CheckCommand { get; private set; }

        public InitDatabaseViewModel()
        {
            CreateNewCommand = new VerboseCommand(CreateNew);
            FillDataCommand = new VerboseCommand(FillData);
            CheckCommand = new VerboseCommand(Check);
            if (IsInDesignMode)
            {
                Pays france = new Pays();
                Region bourgogne = new Region();
                bourgogne.Appellations.Add(new Appellation { Nom = "Nuits Saint Georges" });
                bourgogne.Appellations.Add(new Appellation { Nom = "Pouilly Fumé" });
                france.Regions.Add(bourgogne);
                Region bordeaux = new Region();
                bordeaux.Appellations.Add(new Appellation { Nom = "Chateau Margaux" });
                bordeaux.Appellations.Add(new Appellation { Nom = "Chateau Yquem" });
                france.Regions.Add(bordeaux);
                Pays italie = new Pays();
                this.Pays = new ObservableCollection<Pays>(new Pays[] { france, italie });
            }
        }

        private void CreateNew()
        {
            DatabaseSchemaUpdater dbUpdater;
            // Re-création forcée de la base de données
            using (WineDatacontext db = new WineDatacontext(App.ConnectionString))
            {

                // Si elle existe déjà, on confirme sa suppression
                if (db.DatabaseExists())
                {
                    dbUpdater = db.CreateDatabaseSchemaUpdater();
                    if (MessageBox.Show("La base existe déjà, voulez-vous vraiment la supprimer ?", "Confirmation", MessageBoxButton.OKCancel) == MessageBoxResult.OK)
                    {
                        db.DeleteDatabase();
                    }
                    else if (dbUpdater.DatabaseSchemaVersion < WineDatacontext.SchemaVersion)
                    {
                        dbUpdater.AddColumn<Sortie>("Commentaire");
                        dbUpdater.DatabaseSchemaVersion = WineDatacontext.SchemaVersion;
                        dbUpdater.Execute();

                        return;
                    }
                    else 
                    {
                        return;
                    }
                }
                // Et on peut ensuite la créer
                db.CreateDatabase();

                // Set the new database version.
                dbUpdater = db.CreateDatabaseSchemaUpdater();
                dbUpdater.DatabaseSchemaVersion = WineDatacontext.SchemaVersion;
                dbUpdater.Execute();

            }
        }


        private void FillData()
        {
            var streamInfo = Application.GetResourceStream(new Uri("Data/InitialContent.xml", UriKind.Relative));
            var stream = streamInfo.Stream;
            XDocument initDoc = XDocument.Load(stream, LoadOptions.None);
            using (WineDatacontext db = new WineDatacontext(App.ConnectionString))
            {
                Couleur selectedCouleur = null;
                foreach (var nodeCouleur in initDoc.Descendants("Couleur"))
                {
                    Couleur couleur = new Couleur { Nom = nodeCouleur.Attribute("Nom").Value };
                    db.Couleurs.InsertOnSubmit(couleur);
                    if (selectedCouleur == null) selectedCouleur = couleur;
                }
                db.SubmitChanges();

                TypeGarde selectedTypeGarde = null;
                foreach (var nodeTypeGarde in initDoc.Descendants("TypeGarde"))
                {
                    TypeGarde typeGarde = new TypeGarde { Libelle= nodeTypeGarde.Attribute("Nom").Value };
                    db.TypesGardes.InsertOnSubmit(typeGarde);
                    if (selectedTypeGarde == null) selectedTypeGarde = typeGarde;
                }
                db.SubmitChanges(); 

                Dictionary<string, Pays> listePays = new Dictionary<string, Pays>();
                foreach (var nodePays in initDoc.Descendants("Pays"))
                {
                    Pays pays = new Pays { Nom=nodePays.Attribute("Nom").Value};
                    listePays[pays.Nom] = pays;
                    db.Pays.InsertOnSubmit(pays);
                }
                db.SubmitChanges();

                Dictionary<string, TypeAppellation> listeTypesAppellations = new Dictionary<string, TypeAppellation>();
                int ordre = 0;
                foreach (var nodeTypeAppellation in initDoc.Descendants("TypeAppellation"))
                {
                    TypeAppellation typeAppellation = new TypeAppellation { Nom = nodeTypeAppellation.Attribute("Nom").Value, Abreviation=nodeTypeAppellation.Attribute("Abreviation").Value, Ordre=++ordre };
                    listeTypesAppellations[typeAppellation.Nom] = typeAppellation;
                    db.TypesAppellation.InsertOnSubmit(typeAppellation);
                }
                db.SubmitChanges();

                Dictionary<string, Region> listeRegions = new Dictionary<string, Region>();
                foreach (var nodeRegion in initDoc.Descendants("Region"))
                {
                    Pays pays = listePays[nodeRegion.Attribute("Pays").Value];
                    Region region = new Region { Nom = nodeRegion.Attribute("Nom").Value, Pays=pays };
                    listeRegions[region.Nom] = region;
                    db.Regions.InsertOnSubmit(region);
                }
                db.SubmitChanges();


                Dictionary<string, SousRegion> listeSousRegions = new Dictionary<string, SousRegion>();
                foreach (var nodeRegion in initDoc.Descendants("SousRegion"))
                {
                    Region region = listeRegions[nodeRegion.Attribute("Region").Value];
                    SousRegion sousRegion = new SousRegion { Nom = nodeRegion.Attribute("Nom").Value, Region=region };
                    listeSousRegions[sousRegion.Nom] = sousRegion;
                    db.SousRegions.InsertOnSubmit(sousRegion);
                }
                db.SubmitChanges();

                Appellation selectedAppellation = null;
                foreach (var nodeAppellation in initDoc.Descendants("Appellation"))
                {
                    Region region = listeRegions[nodeAppellation.Attribute("Region").Value];
                    SousRegion sousRegion = null; 
                    XAttribute attSousRegion = nodeAppellation.Attribute("SousRegion");
                    if ((attSousRegion != null) && !string.IsNullOrEmpty(attSousRegion.Value))
                    {
                        sousRegion = listeSousRegions[attSousRegion.Value];
                    }
                    TypeAppellation typeAppellation = listeTypesAppellations[nodeAppellation.Attribute("TypeAppellation").Value];
                    Appellation appellation = new Appellation
                    {
                        Nom = nodeAppellation.Attribute("Nom").Value,
                        Region = region,
                        SousRegion = sousRegion,
                        TypeAppellation = typeAppellation
                    };
                    db.Appellations.InsertOnSubmit(appellation);
                    if (selectedAppellation == null) selectedAppellation = appellation;
                }
                db.SubmitChanges();

                Vin nouveau = new Vin { Appellation=selectedAppellation, Nom="Chateau La Pompe", TypeGarde=selectedTypeGarde, Couleur=selectedCouleur};
                db.Vins.InsertOnSubmit(nouveau);
                db.SubmitChanges();
            }
        }

        private ObservableCollection<Pays> _pays;
        public ObservableCollection<Pays> Pays {
            get { return _pays; }
            set
            {
                if (_pays != value)
                {
                    _pays = value;
                    OnPropertyChanged("Pays");
                }
            }
        }
        private void Check()
        {
            Referentiel.Reset();
            var regions = Referentiel.Regions;
            Pays = Referentiel.Pays;
        }
    }
}
