﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Linq;
using PhoneClassLibrary1;
using System.Collections.ObjectModel;

namespace PivotApp1
{
    public class ModificationViewModel : BindableObject, IActivatable
    {
        private WineDatacontext _db;

        public ICommand NouveauCommand { get; private set; }
        public ICommand ApplyCommand { get; private set; }
        public ICommand DeleteCommand { get; private set; }

        private ObservableCollection<Appellation> _appellations;
        public ObservableCollection<Appellation> Appellations
        {
            get
            {
                return _appellations;
            }
            set
            {
                if (_appellations != value)
                {
                    _appellations = value;
                    OnPropertyChanged("Appellations");
                }
            }
        }
        private ObservableCollection<Couleur> _couleurs;
        public ObservableCollection<Couleur> Couleurs
        {
            get { return _couleurs; }
            set
            {
                if (_couleurs != value)
                {
                    _couleurs = value;
                    OnPropertyChanged("Couleurs");
                }
            }
        }
        private ObservableCollection<TypeGarde> _typesGarde;
        public ObservableCollection<TypeGarde> TypesGarde
        {
            get
            {
                return _typesGarde;
            }
            set
            {
                if (_typesGarde != value)
                {
                    _typesGarde = value;
                    OnPropertyChanged("TypesGarde");
                }
            }
        }
        private Vin _vinCourant;
        public Vin VinCourant
        {
            get { return _vinCourant; }
            set
            {
                if (_vinCourant != value)
                {
                    _vinCourant = value;
                    OnPropertyChanged("VinCourant");
                    OnPropertyChanged("NoSelection");
                    OnPropertyChanged("HasSelection");
                    OnPropertyChanged("CouleurCourante");
                    OnPropertyChanged("AppellationCourante");
                    OnPropertyChanged("TypeGardeCourant");
                }
            }
        }
        public Couleur CouleurCourante
        {
            get
            {
                if (_vinCourant != null)
                {
                    return _vinCourant.Couleur;
                }
                else if (Couleurs != null)
                {
                    return Couleurs.FirstOrDefault();
                }
                else
                {
                    return null;
                }
            }
            set
            {
                if (_vinCourant != null)
                {
                    _vinCourant.Couleur = value;
                }
            }
        }
        public Appellation AppellationCourante
        {
            get
            {
                if (_vinCourant != null)
                {
                    return _vinCourant.Appellation;
                }
                else if (Appellations != null)
                {
                    return Appellations.FirstOrDefault();
                }
                else
                {
                    return null;
                }
            }
            set
            {
                if (_vinCourant != null)
                {
                    _vinCourant.Appellation = value;
                }
            }
        }
        public TypeGarde TypeGardeCourant
        {
            get
            {
                if (_vinCourant != null)
                {
                    return _vinCourant.TypeGarde;
                }
                else if (TypesGarde != null)
                {
                    return TypesGarde.FirstOrDefault();
                }
                else
                {
                    return null;
                }
            }
            set
            {
                if (_vinCourant != null)
                {
                    _vinCourant.TypeGarde = value;
                }
            }
        }
        private ObservableCollection<Vin> _vins;
        public ObservableCollection<Vin> Vins
        {
            get { return _vins; }
            set
            {
                if (_vins != value)
                {
                    _vins = value;
                    OnPropertyChanged("Vins");
                }
            }
        }
        public bool NoSelection
        {
            get { return VinCourant == null; }
        }
        public bool HasSelection
        {
            get { return VinCourant != null; }
        }
        public ModificationViewModel()
        {
            NouveauCommand = new VerboseCommand(Nouveau);
            ApplyCommand = new VerboseCommand(Apply);
            DeleteCommand = new VerboseCommand(Delete);
            if (IsInDesignMode)
            {
                Appellations = new ObservableCollection<Appellation>(new Appellation[] {
                    new Appellation { Nom="Chateau Margaux", TypeAppellation= new TypeAppellation{ Nom="AOC"}, Region=new Region {Nom="Bordeaux"}},  
                    new Appellation { Nom="Chasse-Pleen", TypeAppellation= new TypeAppellation{ Nom="AOC"}, Region=new Region {Nom="Bordeaux"}},  
                    new Appellation { Nom="Pallotte", TypeAppellation= new TypeAppellation{ Nom="AOC"}, Region=new Region {Nom="Bourgogne"}},  
                });
                VinCourant = new Vin { Appellation = Appellations[0], Nom = "Super vin" };
            }
        }

        public void LoadData()
        {
            {
                try
                {
                    _db = new WineDatacontext(App.ConnectionString);
                    var appellationsQuery = from Appellation a in _db.Appellations orderby a.Nom select a;
                    Appellations = new ObservableCollection<Appellation>(appellationsQuery);
                    var couleursQuery = from Couleur c in _db.Couleurs orderby c.Nom select c;
                    Couleurs = new ObservableCollection<Couleur>(couleursQuery);
                    var typesGardeQuery = from TypeGarde tg in _db.TypesGardes orderby tg.Ordre select tg;
                    TypesGarde = new ObservableCollection<TypeGarde>(typesGardeQuery);
                    var vinQuery = from Vin vin in _db.Vins select vin;
                    Vins = new ObservableCollection<Vin>(vinQuery);
                }
                catch (Exception ex)
                {
                    // On ne fait rien, c'est juste un petit sample...
                }
            }
        }



        private void Nouveau()
        {
            Vin nouveau = new Vin();
            nouveau.Appellation = Appellations.FirstOrDefault();
            nouveau.Couleur = Couleurs.FirstOrDefault();
            nouveau.TypeGarde = TypesGarde.FirstOrDefault();
            _db.Vins.InsertOnSubmit(nouveau);
            Vins.Add(nouveau);
            VinCourant = nouveau;
        }

        private void Apply()
        {
            ResetSelection();
        }

        private void Delete()
        {
            if (VinCourant != null)
            {
                Vin vin = VinCourant;
                ResetSelection();
                _db.Vins.DeleteOnSubmit(vin);
                Vins.Remove(vin);
            }
        }


        public void Activate()
        {
            LoadData();
        }

        public void DeActivate()
        {
            try
            {
                var cs = _db.GetChangeSet();
                int nbInserts = cs.Inserts.Count;
                int nbDeletes = cs.Deletes.Count;
                int nbUpdates = cs.Updates.Count;
                _db.SubmitChanges();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            _db.Dispose();
        }

        void ResetSelection()
        {
            try
            {
                VinCourant = null;
            }
            catch
            {
                // Exception effacée
            }
        }
    }
}
