﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using PhoneClassLibrary1;
using System.Collections.ObjectModel;
using System.Linq;
using System.Data.Linq;

namespace PivotApp1
{
    public class SampleRequestsViewModel : BindableObject, IActivatable
    {
        private WineDatacontext _db;

        public ICommand SelectSimpleCommand { get; private set; }
        public ICommand SelectPagineCommand { get; private set; }
        public ICommand SelectPlusFilleCommand { get; private set; }

        private ObservableCollection<Region> _regionsSimples;
        public ObservableCollection<Region> RegionsSimples
        {
            get { return _regionsSimples; }
            set
            {
                if (_regionsSimples != value)
                {
                    _regionsSimples  = value;
                    _regions = null;
                    OnPropertyChanged("Regions");
                    OnPropertyChanged("RegionsSimples");
                }
            }
        }
        private ObservableCollection<Region> _regions;
        public ObservableCollection<Region> Regions
        {
            get { return _regions; }
            set
            {
                if (_regions != value)
                {
                    _regionsSimples = null;
                    _regions = value;
                    OnPropertyChanged("Regions");
                    OnPropertyChanged("RegionsSimples");
                }
            }
        }
        public SampleRequestsViewModel()
        {
            SelectSimpleCommand = new RelayCommand(SelectSimple);
            SelectPagineCommand = new RelayCommand(SelectPagine);
            SelectPlusFilleCommand = new RelayCommand(SelectPlusFille);
        }

        private void SelectSimple()
        {
            var query = from Region r in _db.Regions where r.Pays.Nom == "France" orderby r.Nom select r;
            RegionsSimples = new ObservableCollection<Region>(query);
        }
        private void SelectPagine()
        {
            var query = from Region r in _db.Regions where r.Pays.Nom == "France" orderby r.Nom select r;
            RegionsSimples = new ObservableCollection<Region>(query.Skip(2).Take(2));            
        }
        private void SelectPlusFille()
        {
            DataLoadOptions options = new DataLoadOptions();
            options.LoadWith<Region>(r => r.Appellations);
            var query = from Region r in _db.Regions where r.Pays.Nom == "France" orderby r.Nom select r;
            Regions = new ObservableCollection<Region>(query);
        }


        public void Activate()
        {
            _db = new WineDatacontext(App.ConnectionString);
        }

        public void DeActivate()
        {
            _db.Dispose();
        }
    }
}
