var gBrowser;
var gPrefService;

function gInit() {
	gBrowser = document.getElementById("tbrowser");
	gPrefService = Components.classes["@mozilla.org/preferences-service;1"].
		getService(Components.interfaces.nsIPrefBranch);
	gBrowser.addProgressListener(gListener);
	gGoHome();
}




function gSetHomePage() {
	gPrefService.setCharPref("tinybrowser.homepage", gBrowser.currentURI.spec);
}

function gGoHome() {
	var homePageURI = gPrefService.getCharPref("tinybrowser.homepage");
	gBrowser.loadURI(homePageURI);
}

function gLoadURI() {
	var uri = document.getElementById("tb-URI").value;
	gBrowser.loadURI(uri);
}
function gGoBack() {
	if (gBrowser.canGoBack)
		gBrowser.goBack();
}

function gGoForward() {
	if (gBrowser.canGoForward)
		gBrowser.goForward();
}



/*
 * Listener
 */

const gListener = {
	  QueryInterface: function (aIID) {
	    if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
					aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
					aIID.equals(Components.interfaces.nsISupports)) {
				return this;
			}
			throw Components.results.NS_ERROR_NO_INTERFACE;
		},
		onLocationChange: function ( webProgress, request, location) {
			document.getElementById("tb-URI").value = location.spec;
		},
		onStateChange: function (webProgress, request, stateFlags, status) {
			if (stateFlags & Components.interfaces.nsIWebProgressListener.STATE_STOP) {
				document.getElementById("title").setAttribute("label", gBrowser.contentTitle);
			}
		},
		onProgressChange: function () {return null;},
		onSecurityChange: function () {return null;},
		onStatusChange: function () {return null;},
		GetWeakReference: function () {return null;}
};






