#include "StdAfx.h"
#include "AZCommandLineInfo.h"
#pragma warning(disable:4482)

LPCTSTR CAZCommandLineInfo::TabCommands[] = {
	_T("Close all files"), _T("/CloseAll"),
	_T("Show files"), _T("/ShowFiles"),
	_T("Show pictures"), _T("/ShowPictures"),
	NULL
};

CAZCommandLineInfo::CAZCommandLineInfo(void)
{
	m_command = Command::None;
}

CAZCommandLineInfo::~CAZCommandLineInfo(void)
{
}

void CAZCommandLineInfo::ParseParam(LPCTSTR pszParam, BOOL bFlag, BOOL bLast)
{
	CCommandLineInfo::ParseParam(pszParam, bFlag, bLast);
	if (bFlag && (_tcsicmp(pszParam, _T("closeall")) == 0)) {
		m_command = Command::CloseAllFiles;
	} else if (bFlag && (_tcsicmp(pszParam, _T("showfiles")) == 0)) {
		m_command = Command::ShowFiles;
	} else if (bFlag && (_tcsicmp(pszParam, _T("showpictures")) == 0)) {
		m_command = Command::ShowPictures;
	} else if (bFlag && (_tcsicmp(pszParam, _T("open")) == 0)) {
		m_command = Command::OpenFile;
	} else if (bFlag && (_tcsicmp(pszParam, _T("install")) == 0)) {
		m_command = Command::Install;
	}
}
