// AZTabCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "BarreTachesSeven.h"
#include "AZTabCtrl.h"


// CAZTabCtrl

IMPLEMENT_DYNAMIC(CAZTabCtrl, CTabCtrl)

CAZTabCtrl::CAZTabCtrl()
{
	m_pCurPage = NULL;
}

CAZTabCtrl::~CAZTabCtrl()
{
}


BEGIN_MESSAGE_MAP(CAZTabCtrl, CTabCtrl)
	//{{AFX_MSG_MAP(CAZTabCtrl)
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



// CAZTabCtrl message handlers
void CAZTabCtrl::AddPage(CDialog *pDlg, UINT idTemplate, LPCTSTR sTitle)
{
	m_tabPages.AddTail(pDlg);
	pDlg->Create(idTemplate, this);
	InsertItem(999, sTitle);
	if (m_pCurPage == NULL) {
		pDlg->ShowWindow(SW_SHOW);
		m_pCurPage = pDlg;
	} else {
		pDlg->ShowWindow(SW_HIDE);
	}
	RecalcLayout();
}

void CAZTabCtrl::RecalcLayout()
{
	// Mthode copie de Codeguru...
	CRect tabRect, itemRect;
	int nX, nY, nXc, nYc;

	GetClientRect(&tabRect);
	GetItemRect(0, &itemRect);

	nX=itemRect.left;
	nY=itemRect.bottom+1;
	nXc=tabRect.right-itemRect.left-1;
	nYc=tabRect.bottom-nY-1;

	POSITION pos = m_tabPages.GetHeadPosition();
	while (pos != NULL) {
		CDialog *pDlg = m_tabPages.GetNext(pos);
		pDlg->SetWindowPos(&wndTop, nX, nY, nXc, nYc, (pDlg == m_pCurPage) ? SWP_SHOWWINDOW : SWP_HIDEWINDOW);
	}
}

void CAZTabCtrl::ActivateTab(CDialog *pNewFocus)
{
	if (m_pCurPage != pNewFocus) {
		m_pCurPage->ShowWindow(SW_HIDE);
		pNewFocus->ShowWindow(SW_SHOW);
		pNewFocus->SetFocus();
		m_pCurPage = pNewFocus;
	}
}

void CAZTabCtrl::Activate(CDialog *pNewFocus)
{
	int index = 0;
	POSITION pos = m_tabPages.GetHeadPosition();
	while (pos != NULL) {
		CDialog *pDlg = m_tabPages.GetNext(pos);
		if (pDlg == pNewFocus) {
			SetCurFocus(index);
			ActivateTab(pDlg);
			return;
		} else {
			index++;
		}
	}
}
void CAZTabCtrl::OnLButtonDown(UINT nFlags, CPoint point)
{
	CTabCtrl::OnLButtonDown(nFlags, point);
	int n = GetCurFocus();
	POSITION pos = m_tabPages.FindIndex(n);
	CDialog *pNewFocus = m_tabPages.GetAt(pos);
	Activate(pNewFocus);

}