
// BarreTachesSeven.cpp : Dfinit les comportements de classe pour l'application.
//

#include "stdafx.h"
#include "BarreTachesSeven.h"
#include "BarreTachesSevenDlg.h"
#include "ToolbarHelper.h"
#include "AZCommandLineInfo.h"
#include "DlgProxy.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CBarreTachesSevenApp

BEGIN_MESSAGE_MAP(CBarreTachesSevenApp, CWinAppEx)
	ON_COMMAND(ID_HELP, &CWinApp::OnHelp)
END_MESSAGE_MAP()


// construction CBarreTachesSevenApp

CBarreTachesSevenApp::CBarreTachesSevenApp()
{
	// Placez toutes les initialisations significatives dans InitInstance
	RegisterAppId();
}


// Seul et unique objet CBarreTachesSevenApp

CBarreTachesSevenApp theApp;

const GUID CDECL BASED_CODE _tlid =
		{ 0xFCE56FDA, 0x8FD9, 0x400F, { 0xB5, 0x7D, 0xFF, 0x17, 0xC5, 0xE6, 0xA2, 0xB1 } };
const WORD _wVerMajor = 1;
const WORD _wVerMinor = 0;


// initialisation de CBarreTachesSevenApp

BOOL CBarreTachesSevenApp::InitInstance()
{
	// InitCommonControlsEx() est requis sur WindowsXP si le manifeste de l'application
	// spcifie l'utilisation de ComCtl32.dll version6 ou ultrieure pour activer les
	// styles visuels.  Dans le cas contraire, la cration de fentres chouera.
	INITCOMMONCONTROLSEX InitCtrls;
	InitCtrls.dwSize = sizeof(InitCtrls);
	//  dfinir pour inclure toutes les classes de contrles communs  utiliser
	// dans votre application.
	InitCtrls.dwICC = ICC_WIN95_CLASSES;
	InitCommonControlsEx(&InitCtrls);

	// Initialiser les bibliothques OLE
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}

	CWinAppEx::InitInstance();


	AfxEnableControlContainer();

	// Initialisation standard
	// Si vous n'utilisez pas ces fonctionnalits et que vous souhaitez rduire la taille
	// de votre excutable final, vous devez supprimer ci-dessous
	// les routines d'initialisation spcifiques dont vous n'avez pas besoin.
	// Changez la cl de Registre sous laquelle nos paramtres sont enregistrs
	SetRegistryKey(_T("Alainza\\BarreTachesSeven"));
	// Analyser la ligne de commande pour rechercher les commutateurs automation ou reg/unreg.
	CAZCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	if (cmdInfo.GetCommand() == CAZCommandLineInfo::Install) {
		CreerRaccourci();
		return FALSE;
	} else if (cmdInfo.GetCommand() != CAZCommandLineInfo::None) {
		if (ExecuteCommand(&cmdInfo)) {
			return FALSE;
		}
	}

	// Personnalisation de la barre de tches
	RegisterProgId();
	RegisterFileType(_T(".txt"));


	CreateCustomToolbar(CAZCommandLineInfo::TabCommands);

	// L'application a t lance avec le commutateur /Unregserver ou /Unregister. Supprimez
	// les entres dans la base de registres.
	if (cmdInfo.m_nShellCommand == CCommandLineInfo::AppUnregister)
	{
		COleObjectFactory::UpdateRegistryAll(FALSE);
		AfxOleUnregisterTypeLib(_tlid, _wVerMajor, _wVerMinor);
		return FALSE;
	}
	// L'application a t lance en mode autonome ou avec d'autres commutateurs (par exemple, /Register
	// ou /Regserver). Mettez  jour les entres du Registre, y compris typelibrary.
	else
	{
		COleObjectFactory::UpdateRegistryAll();
		AfxOleRegisterTypeLib(AfxGetInstanceHandle(), _tlid);
		if (cmdInfo.m_nShellCommand == CCommandLineInfo::AppRegister)
			return FALSE;
		// Inscrire les fabriques de classes via CoRegisterClassObject().
		COleTemplateServer::RegisterAll();

	}

	// Crer un objet pour Automation
	//IUnknown *pUnknown	globalObject.GetControllingUnknown

	CBarreTachesSevenDlg dlg;
	m_pMainWnd = &dlg;
	dlg.SetCommand(&cmdInfo);
	dlg.DoModal();

	// Lorsque la bote de dialogue est ferme, retourner FALSE afin de quitter
	//  l'application, plutt que de dmarrer la pompe de messages de l'application.
	return FALSE;
}


BOOL CBarreTachesSevenApp::ExecuteCommand(CAZCommandLineInfo *pCmdInfo)
{
	IUnknownPtr instance;
	HRESULT hr = GetActiveObject(CBarreTachesSevenDlgAutoProxy::guid, NULL, &instance);
	if (SUCCEEDED(hr)) {
		IDispatchPtr dispatch = instance;
		DISPID dispid;
		variant_t vt;
		DISPPARAMS params = { NULL, NULL, 0, 0};
		switch (pCmdInfo->GetCommand()) {
			case CAZCommandLineInfo::OpenFile:
				vt = pCmdInfo->m_strFileName;
				params.rgvarg = (VARIANTARG*)&vt;
				params.cArgs = 1;
				dispid = 1;
				break;
			case CAZCommandLineInfo::CloseAllFiles:
				dispid = 2;
				break;
			case CAZCommandLineInfo::ShowFiles:
				dispid = 3;
				break;
			case CAZCommandLineInfo::ShowPictures:
				dispid = 4;
				break;
		}
		hr = dispatch->Invoke(dispid, IID_NULL, 0, DISPATCH_METHOD, &params, NULL, NULL, NULL);
		if (FAILED(hr)) {
			Erreur(hr, _T("Invoke"));
		}
		return TRUE;
	} else {
		return FALSE;
	}
}

void CBarreTachesSevenApp::CreerRaccourci()
{
	TCHAR sPath[MAX_PATH];
	if (SHGetSpecialFolderPath(NULL, sPath, CSIDL_DESKTOP, FALSE)) {
		StringCchCat(sPath, MAX_PATH, _T("\\Barre Tches Seven.lnk"));
		if (CreateApplicationShortcut(sPath)) {
			MessageBox(NULL, _T("Raccourci cr"), _T("Barre Tches Seven"), MB_OK);
		}
	}
}
