
// BarreTachesSevenDlg.cpp : fichier d'implmentation
//

#include "stdafx.h"
#include "BarreTachesSeven.h"
#include "BarreTachesSevenDlg.h"
#include "DlgProxy.h"
#include "ToolbarHelper.h"
#include "AZCommandLineInfo.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// bote de dialogue CAboutDlg utilise pour la bote de dialogue ' propos de' pour votre application

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Donnes de bote de dialogue
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // Prise en charge de DDX/DDV

// Implmentation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// bote de dialogue CBarreTachesSevenDlg




IMPLEMENT_DYNAMIC(CBarreTachesSevenDlg, CDialog);

CBarreTachesSevenDlg::CBarreTachesSevenDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBarreTachesSevenDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_pAutoProxy = NULL;
	m_pCommand = NULL;
}

CBarreTachesSevenDlg::~CBarreTachesSevenDlg()
{
	// S'il existe un proxy Automation pour cette bote de dialogue, dfinir
	//  la valeur NULL pour son pointeur de retour vers cette bote de dialogue, afin qu'il sache
	//  que celle-ci a t supprime.
	if (m_pAutoProxy != NULL)
		m_pAutoProxy->m_pDialog = NULL;
}

void CBarreTachesSevenDlg::SetCommand(CAZCommandLineInfo *pCommand)
{
	m_pCommand = pCommand;
}

void CBarreTachesSevenDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB1, m_tabCtrl);
}

BEGIN_MESSAGE_MAP(CBarreTachesSevenDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_CLOSE()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(IDC_BACK, &CBarreTachesSevenDlg::OnBack)
	ON_COMMAND(IDC_HOME, &CBarreTachesSevenDlg::OnHome)
	ON_COMMAND(IDC_FORWARD, &CBarreTachesSevenDlg::OnForward)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


// gestionnaires de messages pour CBarreTachesSevenDlg

BOOL CBarreTachesSevenDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	SetAppId(m_hWnd);
	// Ajouter l'lment de menu " propos de..." au menu Systme.

	// IDM_ABOUTBOX doit se trouver dans la plage des commandes systme.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Dfinir l'icne de cette bote de dialogue. L'infrastructure effectue cela automatiquement
	//  lorsque la fentre principale de l'application n'est pas une bote de dialogue
	SetIcon(m_hIcon, TRUE);			// Dfinir une grande icne
	SetIcon(m_hIcon, FALSE);		// Dfinir une petite icne

	m_tabCtrl.AddPage(&m_fichiers, CFichiersDlg::IDD, _T("Fichiers"));
	m_tabCtrl.AddPage(&m_photos, CPhotosDlg::IDD, _T("Photos"));
	m_tabCtrl.AddPage(&m_divers, CDiversDlg::IDD, _T("Divers"));

	// Maintenant, on essaie de publier un objet global pour se laisser piloter par de nouvelles instances
	CCmdTarget *pGlobal = dynamic_cast<CCmdTarget*>(CBarreTachesSevenDlgAutoProxy::CreateObject());
	m_pSharedObject = pGlobal->GetControllingUnknown();
	HRESULT hr = RegisterActiveObject(m_pSharedObject, CBarreTachesSevenDlgAutoProxy::guid, ACTIVEOBJECT_STRONG, &m_dwRegister);
	if (FAILED(hr)) {
		Erreur(hr, _T("RegisterActiveObject"));
	}

	if (m_pCommand) {
		switch (m_pCommand->GetCommand()) {
			case CAZCommandLineInfo::OpenFile:
				OpenFile(m_pCommand->m_strFileName);
				break;
			case CAZCommandLineInfo::CloseAllFiles:
				CloseAllFiles();
				break;
			case CAZCommandLineInfo::ShowFiles:
				ShowFiles();
				break;
			case CAZCommandLineInfo::ShowPictures:
				ShowPictures();
				break;
		}
	}
    ChangeWindowMessageFilter(WM_COMMAND, MSGFLT_ADD);

	return TRUE;  // retourne TRUE, sauf si vous avez dfini le focus sur un contrle
}

void CBarreTachesSevenDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// Si vous ajoutez un bouton Rduire  votre bote de dialogue, vous devez utiliser le code ci-dessous
//  pour dessiner l'icne. Pour les applications MFC utilisant le modle Document/Vue,
//  cela est fait automatiquement par l'infrastructure.

void CBarreTachesSevenDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // contexte de priphrique pour la peinture

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Centrer l'icne dans le rectangle client
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Dessiner l'icne
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// Le systme appelle cette fonction pour obtenir le curseur  afficher lorsque l'utilisateur fait glisser
//  la fentre rduite.
HCURSOR CBarreTachesSevenDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

// Les serveurs Automation ne doivent pas quitter lorsqu'un utilisateur ferme l'interface utilisateur
//  alors qu'un contrleur est encore plac sur l'un de ses objets. Ces
//  gestionnaires de messages s'assurent que
//  l'interface utilisateur est masque si le proxy est en cours d'utilisation, mais que la bote de dialogue demeure s'il est
//  ferm.

void CBarreTachesSevenDlg::OnClose()
{
	if (m_pSharedObject) {
		RevokeActiveObject(m_dwRegister, NULL);
		m_pSharedObject->Release();
		m_pSharedObject = NULL;
	}
	if (CanExit())
		CDialog::OnClose();
}

void CBarreTachesSevenDlg::OnOK()
{
	if (CanExit())
		CDialog::OnOK();
}

void CBarreTachesSevenDlg::OnCancel()
{
	if (CanExit())
		CDialog::OnCancel();
}

BOOL CBarreTachesSevenDlg::CanExit()
{
	// Si l'objet proxy est encore prsent, le contrleur
	//  Automation reste plac sur cette application. Conserver
	//  la bote de dialogue, mais masquer l'interface utilisateur associe.
	if (m_pAutoProxy != NULL)
	{
		ShowWindow(SW_HIDE);
		return FALSE;
	}

	return TRUE;
}

// Mthodes appeles par Automation
void CBarreTachesSevenDlg::OpenFile(LPCTSTR sFile)
{
	m_fichiers.OpenFile(sFile);
}

void CBarreTachesSevenDlg::CloseAllFiles()
{
	m_fichiers.CloseAllFiles();
}

void CBarreTachesSevenDlg::ShowFiles()
{
	m_tabCtrl.Activate(&m_fichiers);
}

void CBarreTachesSevenDlg::ShowPictures()
{
	m_tabCtrl.Activate(&m_photos);
}

void CBarreTachesSevenDlg::OnBack()
{
	SetForegroundWindow();
	AfxMessageBox(_T("Back"));
}

void CBarreTachesSevenDlg::OnHome()
{
	SetForegroundWindow();
	AfxMessageBox(_T("Home"));
}

void CBarreTachesSevenDlg::OnForward()
{
	SetForegroundWindow();
	AfxMessageBox(_T("Forward"));
}

BOOL CBarreTachesSevenDlg::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	switch (nID) {
	case IDC_BACK:
		OnBack();
		return TRUE;
	case IDC_HOME:
		OnHome();
		return TRUE;
	case IDC_FORWARD:
		OnForward();
		return TRUE;
	default:
	   return CDialog::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
	}
}
