
// BarreTachesSevenDlg.h : fichier d'en-tte
//

#pragma once
#include "afxwin.h"
#include "afxcmn.h"
#include "AZTabCtrl.h"
#include "FichiersDlg.h"
#include "PhotosDlg.h"
#include "DiversDlg.h"

class CBarreTachesSevenDlgAutoProxy;
class CAZCommandLineInfo;

// bote de dialogue CBarreTachesSevenDlg
class CBarreTachesSevenDlg : public CDialog
{
	DECLARE_DYNAMIC(CBarreTachesSevenDlg);
	friend class CBarreTachesSevenDlgAutoProxy;

// Construction
public:
	CBarreTachesSevenDlg(CWnd* pParent = NULL);	// constructeur standard
	virtual ~CBarreTachesSevenDlg();
	void SetCommand(CAZCommandLineInfo *pCommand);

// Donnes de bote de dialogue
	enum { IDD = IDD_BARRETACHESSEVEN_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// Prise en charge de DDX/DDV


// Implmentation
protected:
	CBarreTachesSevenDlgAutoProxy* m_pAutoProxy;
	CAZCommandLineInfo *m_pCommand;
	HICON m_hIcon;

	BOOL CanExit();

	// Fonctions gnres de la table des messages
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnClose();
	virtual void OnOK();
	virtual void OnCancel();
	DECLARE_MESSAGE_MAP()
protected:
	CAZTabCtrl m_tabCtrl;
	CFichiersDlg m_fichiers;
	CPhotosDlg m_photos;
	CDiversDlg m_divers;

public:
	// Mthodes appeles par Automation
	void OpenFile(LPCTSTR sFile);
	void CloseAllFiles();
	void ShowFiles();
	void ShowPictures();
	afx_msg void OnBack();
	afx_msg void OnHome();
	afx_msg void OnForward();

	IUnknown *m_pSharedObject;
	DWORD m_dwRegister;

	BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);

};
