// DiversDlg.cpp : implementation file
//

#include "stdafx.h"
#include "BarreTachesSeven.h"
#include "DiversDlg.h"
#include "Resource.h"
#include "Toolbarhelper.h"
#include "BarreTachesSevenDlg.h"

// CDiversDlg dialog

IMPLEMENT_DYNAMIC(CDiversDlg, CDialog)

CDiversDlg::CDiversDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDiversDlg::IDD, pParent)
{
}

CDiversDlg::~CDiversDlg()
{
}

void CDiversDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SLIDER1, m_slider);
}


BEGIN_MESSAGE_MAP(CDiversDlg, CDialog)
	ON_BN_CLICKED(IDC_CHK_OVERLAY, &CDiversDlg::OnBnClickedChkOverlay)
	ON_BN_CLICKED(IDC_CHK_INDICATEUR_AVANCEMENT, &CDiversDlg::OnBnClickedChkIndicateurAvancement)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_CHK_BOUTONS, &CDiversDlg::OnBnClickedChkBoutons)
	ON_BN_CLICKED(IDC_BTN_RACCOURCI, &CDiversDlg::OnBnClickedBtnRaccourci)
END_MESSAGE_MAP()

static THUMBBUTTON g_buttons[3];
static int g_nbButtons = sizeof(g_buttons) / sizeof(g_buttons[0]);

BOOL CDiversDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	HRESULT hr = m_taskBar.CreateInstance(CLSID_TaskbarList);
	if (FAILED(hr)) {
		Erreur(hr, _T("CreateInstance(CLSID_TaskbarList)"));
	} else {
		m_taskBar->HrInit();
	}

	m_slider.SetRange(0, 100, FALSE);
	m_slider.SetPos(20);
	m_hMainWnd = AfxGetMainWnd()->GetSafeHwnd();
	m_images.Create(IDB_BOUTONS, 16, 0, RGB(0,0,0));
	int nbImages = m_images.GetImageCount();

	g_buttons[0].dwMask = THB_BITMAP | THB_TOOLTIP | THB_FLAGS;
	g_buttons[0].iId = IDC_BACK;
	g_buttons[0].dwFlags = THBF_ENABLED | THBF_DISMISSONCLICK | THBF_NOBACKGROUND;
	g_buttons[0].iBitmap = 0;
	int tipLen = sizeof(g_buttons[0].szTip) / sizeof(g_buttons[0].szTip[0]);
	StringCchCopy(g_buttons[0].szTip, tipLen, _T("Naviguer en arrire"));
	g_buttons[1].dwMask = THB_BITMAP | THB_TOOLTIP | THB_FLAGS;
	g_buttons[1].iId = IDC_HOME;
	g_buttons[1].dwFlags = THBF_ENABLED | THBF_DISMISSONCLICK | THBF_NOBACKGROUND;
	g_buttons[1].iBitmap = 1;
	StringCchCopy(g_buttons[1].szTip, tipLen, _T("Revenir  la page d'accueil"));
	g_buttons[2].dwMask = THB_BITMAP | THB_TOOLTIP | THB_FLAGS;
	g_buttons[2].iId = IDC_FORWARD;
	g_buttons[2].dwFlags = THBF_ENABLED | THBF_DISMISSONCLICK | THBF_NOBACKGROUND;
	g_buttons[2].iBitmap = 2;
	StringCchCopy(g_buttons[2].szTip, tipLen, _T("Naviguer en avant"));
	m_bButtonsAdded = FALSE;
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

// CDiversDlg message handlers

void CDiversDlg::OnBnClickedChkOverlay()
{
	BOOL bIcone = IsDlgButtonChecked(IDC_CHK_OVERLAY);
	if (m_taskBar != NULL) {
		HICON hIcon = NULL;
		LPCTSTR sDescription = _T("");
		if (bIcone) {
			hIcon = (HICON)LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_MAIN), IMAGE_ICON, 0, 0, LR_DEFAULTSIZE);
			sDescription = _T("Dmo d'icne");
		}
		HRESULT hr = m_taskBar->SetOverlayIcon(m_hMainWnd, hIcon, sDescription); 
		if (FAILED(hr)) {
			Erreur(hr, _T("SetIconOverlay"));
		}
	}
}



void CDiversDlg::OnBnClickedChkIndicateurAvancement()
{
	if (m_taskBar != NULL) {
		BOOL bProgress = IsDlgButtonChecked(IDC_CHK_INDICATEUR_AVANCEMENT);
		m_slider.EnableWindow(bProgress);
		if (bProgress) {
			m_taskBar->SetProgressState(m_hMainWnd, TBPF_NORMAL);
			m_taskBar->SetProgressValue(m_hMainWnd, m_slider.GetPos(), 100);
		} else {
			m_taskBar->SetProgressState(m_hMainWnd, TBPF_NOPROGRESS);

		}
	}
}



void CDiversDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	if (pScrollBar->IsKindOf (RUNTIME_CLASS(CSliderCtrl))) {
		switch(nSBCode) {
		case TB_THUMBTRACK:
			{
				if (m_taskBar != NULL) {
					m_taskBar->SetProgressValue(m_hMainWnd, m_slider.GetPos(), 100);
				}
			}
			break;
		}
	}
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CDiversDlg::OnBnClickedChkBoutons()
{
	if (m_taskBar != NULL) {
		BOOL bButtons = IsDlgButtonChecked(IDC_CHK_BOUTONS);
		if (bButtons) {
			if (m_bButtonsAdded) {
				// Ils ont t dsactivs prcdemment
				for (int i=0;i<g_nbButtons;i++) {
					g_buttons[i].dwFlags &= ~THBF_HIDDEN;
				}
				HRESULT hr = m_taskBar->ThumbBarUpdateButtons(m_hMainWnd, g_nbButtons, g_buttons);
				if (FAILED(hr)) {
					Erreur(hr, _T("ThumbBarUpdateButtons"));
				}
			} else {
				// C'est le premier ajout
				m_bButtonsAdded = TRUE;
				HRESULT hr = m_taskBar->ThumbBarSetImageList(m_hMainWnd, m_images.GetSafeHandle());
				if (FAILED(hr)) {
					Erreur(hr, _T("ThumbBarSetImageList"));
				}
				hr = m_taskBar->ThumbBarAddButtons(m_hMainWnd, g_nbButtons, g_buttons);
				if (FAILED(hr)) {
					Erreur(hr, _T("ThumbBarAddButtons"));
				}
			}
		} else {
			// On les masque
			for (int i=0;i<g_nbButtons;i++) {
				g_buttons[i].dwFlags |= THBF_HIDDEN;
			}
			HRESULT hr = m_taskBar->ThumbBarUpdateButtons(m_hMainWnd, g_nbButtons, g_buttons);
			if (FAILED(hr)) {
				Erreur(hr, _T("ThumbBarUpdateButtons"));
			}
		}
	}
}



void CDiversDlg::OnBnClickedBtnRaccourci()
{
	((CBarreTachesSevenApp*)AfxGetApp())->CreerRaccourci();
}
