
// DlgProxy.cpp : fichier d'implmentation
//

#include "stdafx.h"
#include "BarreTachesSeven.h"
#include "DlgProxy.h"
#include "BarreTachesSevenDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CBarreTachesSevenDlgAutoProxy

IMPLEMENT_DYNCREATE(CBarreTachesSevenDlgAutoProxy, CCmdTarget)

CBarreTachesSevenDlgAutoProxy::CBarreTachesSevenDlgAutoProxy()
{
	EnableAutomation();
	
	// Pour que l'application continue de s'excuter tant qu'un objet Automation 
	//	est actif, le constructeur appelle AfxOleLockApp.
	AfxOleLockApp();

	// Accder  la bote de dialogue par l'intermdiaire du pointeur
	//  de la fentre principale de l'application. Dfinir le pointeur interne du proxy
	//  pour qu'il pointe vers la bote de dialogue, et dfinir le pointeur de retour de la bote de dialogue pour qu'il pointe vers
	//  ce proxy.
	ASSERT_VALID(AfxGetApp()->m_pMainWnd);
	if (AfxGetApp()->m_pMainWnd)
	{
		ASSERT_KINDOF(CBarreTachesSevenDlg, AfxGetApp()->m_pMainWnd);
		if (AfxGetApp()->m_pMainWnd->IsKindOf(RUNTIME_CLASS(CBarreTachesSevenDlg)))
		{
			m_pDialog = reinterpret_cast<CBarreTachesSevenDlg*>(AfxGetApp()->m_pMainWnd);
			m_pDialog->m_pAutoProxy = this;
		}
	}
}

CBarreTachesSevenDlgAutoProxy::~CBarreTachesSevenDlgAutoProxy()
{
	// Pour mettre fin  l'application lorsque tous les objets ont t crs
	// 	avec Automation, le destructeur appelle AfxOleUnlockApp.
	//  Cela aura notamment pour effet de dtruire la bote de dialogue principale
	if (m_pDialog != NULL)
		m_pDialog->m_pAutoProxy = NULL;
	AfxOleUnlockApp();

}

void CBarreTachesSevenDlgAutoProxy::OnFinalRelease()
{
	// Lorsque la dernire rfrence pour un objet automation est libre
	// OnFinalRelease est appel. La classe de base supprime automatiquement
	// l'objet. Un nettoyage supplmentaire est requis pour votre
	// objet avant d'appeler la classe de base.

	CCmdTarget::OnFinalRelease();
}

BEGIN_MESSAGE_MAP(CBarreTachesSevenDlgAutoProxy, CCmdTarget)
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CBarreTachesSevenDlgAutoProxy, CCmdTarget)
	DISP_FUNCTION_ID(CBarreTachesSevenDlgAutoProxy, "OpenFile", dispidOpenFile, OpenFile, VT_EMPTY, VTS_BSTR)
	DISP_FUNCTION_ID(CBarreTachesSevenDlgAutoProxy, "CloseAllFiles", dispidCloseAllFiles, CloseAllFiles, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION_ID(CBarreTachesSevenDlgAutoProxy, "ShowFiles", dispidShowFiles, ShowFiles, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION_ID(CBarreTachesSevenDlgAutoProxy, "ShowPictures", dispidShowPictures, ShowPictures, VT_EMPTY, VTS_NONE)
END_DISPATCH_MAP()

// Remarque: La prise en charge de IID_IBarreTachesSeven a t ajoute afin de prendre en charge la liaison de type scuris
//   partir de VBA. Cet IID doit correspondre au GUID qui est attach  
//  dispinterface dans le fichier .IDL.

// {C8731A1E-26E1-4083-8669-DBC7E7A17C9F}
static const IID IID_IBarreTachesSeven =
{ 0xC8731A1E, 0x26E1, 0x4083, { 0x86, 0x69, 0xDB, 0xC7, 0xE7, 0xA1, 0x7C, 0x9F } };

BEGIN_INTERFACE_MAP(CBarreTachesSevenDlgAutoProxy, CCmdTarget)
	INTERFACE_PART(CBarreTachesSevenDlgAutoProxy, IID_IBarreTachesSeven, Dispatch)
END_INTERFACE_MAP()

// La macro IMPLEMENT_OLECREATE2 est dfinie dans le fichier StdAfx.h de ce projet
// {9F48DA83-1EEF-42AA-A63B-BC09480A4CC8}
IMPLEMENT_OLECREATE2(CBarreTachesSevenDlgAutoProxy, "BarreTachesSeven.Application", 0x9f48da83, 0x1eef, 0x42aa, 0xa6, 0x3b, 0xbc, 0x9, 0x48, 0xa, 0x4c, 0xc8)


// gestionnaires de messages pour CBarreTachesSevenDlgAutoProxy

void CBarreTachesSevenDlgAutoProxy::OpenFile(LPCTSTR bstrFilename)
{
	AFX_MANAGE_STATE(AfxGetAppModuleState());

	m_pDialog->OpenFile(bstrFilename);
}

void CBarreTachesSevenDlgAutoProxy::CloseAllFiles(void)
{
	AFX_MANAGE_STATE(AfxGetAppModuleState());

	m_pDialog->CloseAllFiles();
}

void CBarreTachesSevenDlgAutoProxy::ShowFiles(void)
{
	AFX_MANAGE_STATE(AfxGetAppModuleState());

	m_pDialog->ShowFiles();
}

void CBarreTachesSevenDlgAutoProxy::ShowPictures(void)
{
	AFX_MANAGE_STATE(AfxGetAppModuleState());

	m_pDialog->ShowPictures();
}
