// FichiersDlg.cpp : implementation file
//

#include "stdafx.h"
#include "BarreTachesSeven.h"
#include "FichiersDlg.h"
#include "ToolbarHelper.h"


// CFichiersDlg dialog

IMPLEMENT_DYNAMIC(CFichiersDlg, CDialog)

CFichiersDlg::CFichiersDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFichiersDlg::IDD, pParent)
{

}

CFichiersDlg::~CFichiersDlg()
{
}

void CFichiersDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST1, m_lbxFichiers);
}


BEGIN_MESSAGE_MAP(CFichiersDlg, CDialog)
	ON_BN_CLICKED(IDC_BTN_OUVRIR, &CFichiersDlg::OnBnClickedBtnOuvrir)
END_MESSAGE_MAP()


// CFichiersDlg message handlers
void CFichiersDlg::OpenFile(LPCTSTR sFile)
{
	m_lbxFichiers.AddString(sFile);
	// Ajout aux fichiers rcents : ceci va automatiquement l'ajouter dans la barre de tches Seven
	AddToRecentDocs(sFile);
}

void CFichiersDlg::CloseAllFiles()
{
	m_lbxFichiers.ResetContent();
}


void CFichiersDlg::OnBnClickedBtnOuvrir()
{
	TCHAR sFile[MAX_PATH];
	sFile[0] = 0;
	OPENFILENAME ofn;
	ZeroMemory(&ofn, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = AfxGetMainWnd()->m_hWnd;
	ofn.hInstance = AfxGetInstanceHandle();
	ofn.lpstrFilter = _T("Text Files\0*.txt\0All files\0*.*\0\0");
	ofn.lpstrFile = sFile;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrTitle = _T("Choisissez un fichier");
	if (GetOpenFileName(&ofn)) {
		OpenFile(sFile);
	}
}
