#include "StdAfx.h"
#include "ToolbarHelper.h"


void Erreur(DWORD dwErr, LPCTSTR sTitle)
{
	TCHAR sBuf[512];
	if (!FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, dwErr, 0, sBuf, 512, NULL)) {
		StringCchPrintf(sBuf, 512, _T("Err 0x%08X"), dwErr);
	}
	::MessageBox(AfxGetMainWnd()->GetSafeHwnd(), sBuf, sTitle, MB_OK | MB_ICONERROR);
}

////////////////////////////////////////////////////////////////////

LPCWSTR wszAppID = L"Alainza.BarreTachesSeven";
LPCWSTR wszProgID = L"Alainza.BarreTachesProgId";

#define BUFSIZE 512

void RegisterProgId()
{
	CRegKey rootKey;
	rootKey.Create(HKEY_CURRENT_USER, _T("Software\\Classes"), NULL, REG_OPTION_NON_VOLATILE, KEY_SET_VALUE | KEY_CREATE_SUB_KEY);

	CRegKey progIdKey;
	int nRet = progIdKey.Create((HKEY)rootKey, wszProgID, NULL, REG_OPTION_NON_VOLATILE, KEY_SET_VALUE | KEY_CREATE_SUB_KEY);
	if (nRet != ERROR_SUCCESS) {
		Erreur(nRet, _T("progIdKey.Create"));
		return;
	}
	progIdKey.SetStringValue(_T("FriendlyTypeName"), _T("@shell32.dll,-8975"));
	progIdKey.SetStringValue(_T("AppUserModelID"), wszAppID);
	progIdKey.SetKeyValue(_T("DefaultIcon"), _T("@shell32.dll,-8975"));
	progIdKey.SetKeyValue(_T("CurVer"), wszProgID);
	CRegKey shellKey;
	shellKey.Create((HKEY)progIdKey, _T("shell"), NULL, REG_OPTION_NON_VOLATILE, KEY_SET_VALUE | KEY_CREATE_SUB_KEY);
	shellKey.SetStringValue(NULL, _T("Open"));
	CRegKey commandKey;
	commandKey.Create((HKEY)shellKey, _T("Open\\Command"), NULL, REG_OPTION_NON_VOLATILE, KEY_SET_VALUE | KEY_CREATE_SUB_KEY);
	TCHAR sCommand[BUFSIZE];
	GetModuleFileName(NULL, sCommand, BUFSIZE);
	StringCchCat(sCommand, BUFSIZE, _T(" /Open %1"));
	commandKey.SetStringValue(NULL, sCommand);

#if FALSE
	CRegKey comAppIdKey;
	comAppIdKey.Create(HKEY_LOCAL_MACHINE, _T("Software\\Classes\\AppId\\BarreTachesSeven.exe"), NULL, REG_OPTION_NON_VOLATILE, KEY_SET_VALUE | KEY_CREATE_SUB_KEY);
	comAppIdKey.SetStringValue(NULL, _T("BarreTachesSeven"));
	comAppIdKey.SetStringValue(_T("AppId"), _T("{38B92A74-784D-4eb1-9E8C-ADD724148766}"));
	CRegKey comGuidKey;
	comGuidKey.Create(HKEY_LOCAL_MACHINE, _T("Software\\Classes\\AppId\\{38B92A74-784D-4eb1-9E8C-ADD724148766}"), NULL, REG_OPTION_NON_VOLATILE, KEY_SET_VALUE | KEY_CREATE_SUB_KEY);
	comGuidKey.SetStringValue(NULL, _T("BarreTachesSeven"));
	comGuidKey.SetStringValue(_T("AppId"), _T("BarreTachesSeven"));
	comGuidKey.SetDWORDValue(_T("AuthenticationLevel"), 1);
#endif
}

void RegisterFileType(LPCTSTR sExt)
{
	CRegKey rootKey;
	rootKey.Create(HKEY_CURRENT_USER, _T("Software\\Classes"), NULL, REG_OPTION_NON_VOLATILE, KEY_SET_VALUE | KEY_CREATE_SUB_KEY);
	TCHAR sKey[128];
	StringCchCopy(sKey, 128, sExt);
	StringCchCat(sKey, 128, _T("\\OpenWithProgids"));
	CRegKey openKey;
	LONG nRet = openKey.Create((HKEY)rootKey, sKey, NULL, REG_OPTION_NON_VOLATILE, KEY_SET_VALUE | KEY_CREATE_SUB_KEY);
	if (nRet != ERROR_SUCCESS) {
		Erreur(nRet, _T("openKey.Create(HKEY_CLASSES_ROOT, OpenWithProgids)"));
	} else {
		openKey.SetStringValue(wszProgID, _T(""));
	}
}

void RegisterAppId()
{
	// 1re tape : prciser le AppId du programme courant
	HRESULT hr = SetCurrentProcessExplicitAppUserModelID(wszAppID);
	if (FAILED(hr)) {
		Erreur(hr, _T("SetCurrentProcessExplicitAppUserModelID"));
	}
}

HRESULT CreateShellLink(LPCWSTR lpszParams, LPCWSTR lpszTitle, IShellLink **ppLink)
{
    IShellLinkPtr link;
    HRESULT hr = link.CreateInstance(CLSID_ShellLink);
	if (FAILED(hr)) {
		Erreur(hr, _T("CoCreateInstance(CLSID_ShellLink"));
		return hr;
	}
    WCHAR szAppPath[MAX_PATH];
	GetModuleFileName(NULL, szAppPath, MAX_PATH);
	hr = link->SetPath(szAppPath);
	if (FAILED(hr)) {
		Erreur(hr, _T("link->SetPath"));
		return hr;
	}
    hr = link->SetArguments(lpszParams);
	if (FAILED(hr)) {
		Erreur(hr, _T("link->SetArguments"));
		return hr;
	}
    IPropertyStorePtr store = link;
    PROPVARIANT propvar;
    hr = InitPropVariantFromString(lpszTitle, &propvar);
	if (FAILED(hr)) {
		Erreur(hr, _T("InitPropVariantFromString"));
		return hr;
	}
    hr = store->SetValue(PKEY_Title, propvar);
	if (FAILED(hr)) {
		Erreur(hr, _T("store"));
		return hr;
	}
    PropVariantClear(&propvar);
    hr = store->Commit();
	if (FAILED(hr)) {
		Erreur(hr, _T("Commit"));
		return hr;
	}
    *ppLink = link.Detach();
	return S_OK;
}
void CreateTaskList(ICustomDestinationList *pList, IObjectArray *pArray, LPCTSTR *pCommands)
{
    IObjectCollectionPtr collection;
    HRESULT hr = collection.CreateInstance(CLSID_EnumerableObjectCollection);
	if (FAILED(hr)) {
		Erreur(hr, _T("collection.CreateInstance(CLSID_EnumerableObjectCollection)"));
		return;
	}
	while (*pCommands) {
		LPCTSTR sCommandName = *pCommands++;
		LPCTSTR sArguments = *pCommands++;
		IShellLinkPtr link;
		hr = CreateShellLink(sArguments, sCommandName, &link);
		if (SUCCEEDED(hr)) {
			hr = collection->AddObject(link);
			if (FAILED(hr)) {
				Erreur(hr, _T("AddObject"));
			}
		}
	}
    IObjectArrayPtr arr = collection;

	hr = pList->AddUserTasks(arr);
	if (FAILED(hr)) {
		Erreur(hr, _T("AddUserTasks"));
	}

}
void CreateCustomToolbar(LPCTSTR *pCommands)
{
	// Constitution de la barre
	ICustomDestinationListPtr customList;
	HRESULT hr = customList.CreateInstance(CLSID_DestinationList);
	if (FAILED(hr)) {
		Erreur(hr, _T("CreateInstance(CLSID_DestinationList)"));
		return;
	}
	// Association de la liste avec l'AppID prcdemment enregistr
	hr = customList->SetAppID(wszAppID);
	if (FAILED(hr)) {
		Erreur(hr, _T("SetAppID(szAppID)"));
		return;
	}
	UINT cMaxSlots;
	IObjectArrayPtr removedObjects;
	// Initialisation de la liste : on rcupre les lments retirs manuellement par l'utilisateur
	hr = customList->BeginList(&cMaxSlots, __uuidof(IObjectArray), (void**)&removedObjects);
	if (FAILED(hr)) {
		Erreur(hr, _T("BeginList()"));
		return;
	}

	// Ajout de la catgorie "Recent files"
	hr = customList->AppendKnownCategory(KDC_RECENT);
	if (FAILED(hr)) {
		Erreur(hr, _T("AppendKnownCategory()"));
		customList->AbortList();
		return;
	}

	// Ajout de la catgorie "tches
	CreateTaskList(customList, removedObjects, pCommands);

	// Finalisation de la liste
	hr = customList->CommitList();
	if (FAILED(hr)) {
		Erreur(hr, _T("CommitList()"));
		return;
	}
}

void SetAppId(HWND hWnd)
{
	IPropertyStorePtr store;
	HRESULT hr = SHGetPropertyStoreForWindow(hWnd, __uuidof(IPropertyStore), (void**)&store);
	if (FAILED(hr)) {
		Erreur(hr, _T("SHGetPropertyStoreForWindow"));
		return;
	}
	PROPVARIANT propvar;
	hr = InitPropVariantFromString(wszAppID, &propvar);
	if (FAILED(hr)) {
		Erreur(hr, _T("InitPropVariantFromString"));
		return;
	}
	hr = store->SetValue(PKEY_AppUserModel_ID, propvar);
	if (FAILED(hr)) {
		Erreur(hr, _T("store->SetValue"));
		return;
	}
    PropVariantClear(&propvar);
    hr = store->Commit();
	if (FAILED(hr)) {
		Erreur(hr, _T("Commit"));
		return;
	}
}

void AddToRecentDocs(LPCTSTR sFile)
{
	SHARDAPPIDINFOLINK linkInfo;
	linkInfo.pszAppID = wszAppID;
	HRESULT hr = CoCreateInstance(CLSID_ShellLink, NULL, CLSCTX_ALL, __uuidof(IShellLink), (void**)&linkInfo.psl);
	if (FAILED(hr)) {
		Erreur(hr, _T("CoCreateInstance(CLSID_ShellLink)"));
		return;
	}
	hr = linkInfo.psl->SetPath(sFile);
	if (FAILED(hr)) {
		Erreur(hr, _T("CoCreateInstance(CLSID_ShellLink)"));
		return;
	}
    IPropertyStorePtr store = linkInfo.psl;
    PROPVARIANT propvar;
    hr = InitPropVariantFromString(wszAppID, &propvar);
	if (FAILED(hr)) {
		Erreur(hr, _T("InitPropVariantFromString"));
		return;
	}
    hr = store->SetValue(PKEY_AppUserModel_ID, propvar);
	if (FAILED(hr)) {
		Erreur(hr, _T("store"));
		return;
	}
    PropVariantClear(&propvar);
    hr = store->Commit();
	if (FAILED(hr)) {
		Erreur(hr, _T("Commit"));
		return;
	}
	SHAddToRecentDocs(SHARD_APPIDINFOLINK, &linkInfo);
	linkInfo.psl->Release();
}

BOOL CreateApplicationShortcut(LPCTSTR sFile)
{
	IShellLinkPtr link;
	HRESULT hr = link.CreateInstance(CLSID_ShellLink);
	if (FAILED(hr)) {
		Erreur(hr, _T("CoCreateInstance(CLSID_ShellLink)"));
		return FALSE;
	}
	TCHAR sPath[MAX_PATH];
	GetModuleFileName(NULL, sPath, MAX_PATH);
	hr = link->SetPath(sPath);
	if (FAILED(hr)) {
		Erreur(hr, _T("CoCreateInstance(CLSID_ShellLink)"));
		return FALSE;
	}
    IPropertyStorePtr store = link;
    PROPVARIANT propvar;
    hr = InitPropVariantFromString(wszAppID, &propvar);
	if (FAILED(hr)) {
		Erreur(hr, _T("InitPropVariantFromString"));
		return FALSE;
	}
    hr = store->SetValue(PKEY_AppUserModel_ID, propvar);
	if (FAILED(hr)) {
		Erreur(hr, _T("store"));
		return FALSE;
	}
    PropVariantClear(&propvar);
    hr = store->Commit();
	if (FAILED(hr)) {
		Erreur(hr, _T("Commit"));
		return FALSE;
	}
	store = NULL;
	IPersistFilePtr file = link;
	hr = file->Save(sFile, TRUE);
	if (FAILED(hr)) {
		Erreur(hr, _T("IPersistFile::Save"));
		return FALSE;
	}
	return TRUE;
}
