﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.Device.Location;

namespace WindowsPhoneApplication1
{
    public partial class Localisation : PhoneApplicationPage
    {
        GeoCoordinateWatcher _geowatcher;

        public Localisation()
        {
            InitializeComponent();
        }
        private void DemarrerLocalisation_Click(object sender, EventArgs e)
        {
            try
            {
                _geowatcher = new GeoCoordinateWatcher(GeoPositionAccuracy.High);
                _geowatcher.MovementThreshold = 20;
                _geowatcher.StatusChanged += new EventHandler<GeoPositionStatusChangedEventArgs>(_geowatcher_StatusChanged);
                _geowatcher.PositionChanged += new EventHandler<GeoPositionChangedEventArgs<GeoCoordinate>>(_geowatcher_PositionChanged);
                _geowatcher.Start();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void ArreterLocalisation_Click(object sender, EventArgs e)
        {
            if (_geowatcher != null)
            {
                _geowatcher.Stop();
            }
        }
void _geowatcher_PositionChanged(object sender, GeoPositionChangedEventArgs<GeoCoordinate> e)
{
    this.Dispatcher.BeginInvoke((Action)delegate()
    {
        LatitudeTextBlock.Text = e.Position.Location.Latitude.ToString();
        LongitudeTextBlock.Text = e.Position.Location.Longitude.ToString();
        AltitudeTextBlock.Text = e.Position.Location.Altitude.ToString();
        VitesseTextBlock.Text = e.Position.Location.Speed.ToString();
    });
}

        void _geowatcher_StatusChanged(object sender, GeoPositionStatusChangedEventArgs e)
        {
            this.Dispatcher.BeginInvoke((Action)delegate()
            {
                switch (e.Status)
                {
                    case GeoPositionStatus.Disabled:
                        StatutTextBlock.Text = "Pas de géolocalisation disponible";
                        break;
                    case GeoPositionStatus.Initializing:
                        StatutTextBlock.Text = "Initialisation en cours...";
                        break;
                    case GeoPositionStatus.NoData:
                        StatutTextBlock.Text = "Pas de données...";
                        break;
                    case GeoPositionStatus.Ready:
                        StatutTextBlock.Text = "Prêt";
                        break;
                }
            });
        }


    }
}