﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.IO;
using System.IO.IsolatedStorage;
namespace WindowsPhoneApplication1
{
    public partial class Storage : PhoneApplicationPage
    {
        public Storage()
        {
            InitializeComponent();
        }

        public void CreerFichier_Click(object sender, EventArgs e)
        {
            try
            {
                using (IsolatedStorageFile store = IsolatedStorageFile.GetUserStoreForApplication())
                {
                    using (FileStream fs = store.CreateFile(NomTextBox.Text))
                    {
                        using (StreamWriter writer = new StreamWriter(fs)) {
                            for (int i=0;i<=new Random().Next(10);i++) {
                                writer.WriteLine("Bonjour chez vous");
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
        public void LireFichier_Click(object sender, EventArgs e)
        {
            try
            {
                using (IsolatedStorageFile store = IsolatedStorageFile.GetUserStoreForApplication())
                {
                    using (FileStream fs = store.OpenFile(NomTextBox.Text, FileMode.Open))
                    {
                        using (StreamReader reader = new StreamReader(fs))
                        {
                            MessageBox.Show(reader.ReadToEnd(), "Contenu", MessageBoxButton.OK);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
        public void EnumererFichiers_Click(object sender, EventArgs e)
        {
            try
            {
using (IsolatedStorageFile store = IsolatedStorageFile.GetUserStoreForApplication())
{
    FichiersListBox.ItemsSource = store.GetFileNames();
}
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void FichiersListBox_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            NomTextBox.Text = FichiersListBox.SelectedItem as string;
        }
    }
}