﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;

namespace WindowsPhoneApplication1
{
    public partial class TextInput : PhoneApplicationPage
    {
        private InputScopeName[] _names = new InputScopeName[] {
            new InputScopeName { NameValue=InputScopeNameValue.AddressCity},
            new InputScopeName { NameValue=InputScopeNameValue.AlphanumericFullWidth},
            new InputScopeName { NameValue=InputScopeNameValue.AlphanumericHalfWidth},
            new InputScopeName { NameValue=InputScopeNameValue.Chat},
            new InputScopeName { NameValue=InputScopeNameValue.CurrencyAmountAndSymbol},
            new InputScopeName { NameValue=InputScopeNameValue.Date},
            new InputScopeName { NameValue=InputScopeNameValue.DateDayName},
            new InputScopeName { NameValue=InputScopeNameValue.DateYear},
            new InputScopeName { NameValue=InputScopeNameValue.Digits},
            new InputScopeName { NameValue=InputScopeNameValue.EmailNameOrAddress},
            new InputScopeName { NameValue=InputScopeNameValue.FileName},
            new InputScopeName { NameValue=InputScopeNameValue.LogOnName},
            new InputScopeName { NameValue=InputScopeNameValue.Maps},
            new InputScopeName { NameValue=InputScopeNameValue.NameOrPhoneNumber},
            new InputScopeName { NameValue=InputScopeNameValue.Number},
            new InputScopeName { NameValue=InputScopeNameValue.NumberFullWidth},
            new InputScopeName { NameValue=InputScopeNameValue.OneChar},
            new InputScopeName { NameValue=InputScopeNameValue.Password},
            new InputScopeName { NameValue=InputScopeNameValue.PersonalFullName},
            new InputScopeName { NameValue=InputScopeNameValue.PostalCode},
            new InputScopeName { NameValue=InputScopeNameValue.Search},
            new InputScopeName { NameValue=InputScopeNameValue.TelephoneCountryCode},
            new InputScopeName { NameValue=InputScopeNameValue.TelephoneNumber},
            new InputScopeName { NameValue=InputScopeNameValue.TelephoneLocalNumber},
            new InputScopeName { NameValue=InputScopeNameValue.Text},
            new InputScopeName { NameValue=InputScopeNameValue.Time},
            new InputScopeName { NameValue=InputScopeNameValue.Url},
        };
        private int _index = 0;
        private InputScope _scope;
        public TextInput()
        {
            InitializeComponent();
            _scope = new InputScope();
            SetScope(0);
        }

        private void SetScope(int index)
        {
            if (index == 0)
            {
                InputNameTextBlock.Text = "Standard";
                TestTextBox.InputScope = null;
            }
            else
            {
                TestTextBox.InputScope = _scope;
                _scope.Names.Clear();
                _scope.Names.Add(_names[index]);
                InputNameTextBlock.Text = _names[index].NameValue.ToString();
                _index = index;
            }
        }

        private void PrecButton_Click(object sender, EventArgs e)
        {
            SetScope((_index - 1) % _names.Length);
        }

        private void NextButton_Click(object sender, EventArgs e)
        {
            SetScope((_index + 1) % _names.Length);
        }
    }
}