﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.ObjectModel;

namespace WindowsPhoneApplication1
{
    public class Tournoi
    {
        public string Sport { get;  set; }
        public string Nom { get; set; }
        public DateTime Debut { get; set; }
        public DateTime Fin { get; set; }
        public string DateDebut { get { return Debut.ToShortDateString(); } }
        public string DateFin { get { return Fin.ToShortDateString(); } }
        public ObservableCollection<string> Resultats { get; private set; }
        public Tournoi()
        {
            this.Resultats = new ObservableCollection<string>();
        }
    }

    public class BaseTournois : ObservableCollection<Tournoi>
    {
        public BaseTournois()
        {
            Tournoi t = new Tournoi { Sport = "Tennis", Nom = "Miami", Debut = new DateTime(2010, 03, 24), Fin = new DateTime(2010, 04, 04) };
            t.Resultats.Add("T.Berdych 4-6 7-6 6-4 F.Verdasco");
            t.Resultats.Add("R.Soderling 6-1 6-4 M.Youzhny");
            t.Resultats.Add("R.Nadal 6-3 6-2 JW.Tsonga");
            t.Resultats.Add("A.Roddick 6-3 6-3 N.Almagro");
            t.Resultats.Add("A.Riddick 4-6 6-3 6-3");
            this.Add(t);
            this.Add(new Tournoi{ Sport ="Tennis", Nom = "Rome", Debut = new DateTime(2010, 04, 25), Fin = new DateTime(2010, 05, 02)});
            this.Add(new Tournoi{ Sport ="Judo", Nom = "Championnat d'Europe", Debut = new DateTime(2010, 04, 23), Fin = new DateTime(2010, 04, 25)});
            this.Add(new Tournoi { Sport = "Echecs", Nom = "Championnat du monde", Debut = new DateTime(2010, 04, 21), Fin = new DateTime(2010, 05, 11) });

        }
    }
}
