﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.Xml;
using System.IO;

namespace WindowsPhoneApplication1
{
    public partial class WebService : PhoneApplicationPage
    {
        public WebService()
        {
            InitializeComponent();
        }

        #region WCF - basicHttpBinding
        private void EstPremier_Click(object sender, EventArgs e)
        {
            try
            {
                int n = int.Parse(NombreTextBox.Text);
                ServiceReference1.CalculatriceClient calculatrice = new ServiceReference1.CalculatriceClient();
                calculatrice.EstPremierCompleted += new EventHandler<ServiceReference1.EstPremierCompletedEventArgs>(calculatrice_EstPremierCompleted);
                calculatrice.EstPremierAsync(n);
                ResultatTextBlock.Text = "En cours...";
            }
            catch (Exception ex)
            {

                MessageBox.Show(ex.Message);
            }
        }

        void calculatrice_EstPremierCompleted(object sender, ServiceReference1.EstPremierCompletedEventArgs e)
        {
            Dispatcher.BeginInvoke((Action)delegate()
            {
                try
                {
                    if (e.Error != null)
                    {
                        MessageBox.Show(e.Error.Message, "Une erreur est survenue", MessageBoxButton.OK);
                    }
                    else
                    {
                        ResultatTextBlock.Text = e.Result.ToString();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
            });
        }

        private void Decomposer_Click(object sender, EventArgs e)
        {
            try
            {
                int n = int.Parse(NombreTextBox.Text);
                ServiceReference1.CalculatriceClient calculatrice = new ServiceReference1.CalculatriceClient();
                calculatrice.DecomposerCompleted += new EventHandler<ServiceReference1.DecomposerCompletedEventArgs>(calculatrice_DecomposerCompleted);
                calculatrice.DecomposerAsync(n);
                ResultatTextBlock.Text = "En cours...";
            }
            catch (Exception ex)
            {

                MessageBox.Show(ex.Message);
            }
        }

        void calculatrice_DecomposerCompleted(object sender, ServiceReference1.DecomposerCompletedEventArgs e)
        {
            Dispatcher.BeginInvoke((Action)delegate()
            {
                try
                {
                    if (e.Error != null)
                    {
                        MessageBox.Show(e.Error.Message, "Une erreur est survenue", MessageBoxButton.OK);
                    }
                    else
                    {
                        ResultatTextBlock.Text = "Terminé";
                        ResultatListBox.ItemTemplate = Resources["FacteurTemplate"] as DataTemplate;
                        ResultatListBox.ItemsSource = e.Result;
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
            });
        }
        #endregion

        #region Web Service ASP.NET Classique
        void Classic_Click(object sender, EventArgs e)
        {
            try
            {
                ServiceReference2.HelloServiceSoapClient proxy = new ServiceReference2.HelloServiceSoapClient();
                proxy.HelloWorldCompleted += new EventHandler<ServiceReference2.HelloWorldCompletedEventArgs>(proxy_HelloWorldCompleted);
                proxy.HelloWorldAsync();
                ResultatTextBlock.Text = "En cours...";
            }
            catch (Exception ex)
            {

                MessageBox.Show(ex.Message);
            }
        }

        void proxy_HelloWorldCompleted(object sender, ServiceReference2.HelloWorldCompletedEventArgs e)
        {
            Dispatcher.BeginInvoke((Action)delegate()
            {
                try
                {
                    if (e.Error != null)
                    {
                        MessageBox.Show(e.Error.Message, "Une erreur est survenue", MessageBoxButton.OK);
                    }
                    else
                    {
                        ResultatTextBlock.Text = e.Result;
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
            });
        }
        #endregion

        #region WCF "Silverlight Enabled"
        void SilverlightEnabled_Click(object sender, EventArgs e)
        {
            try
            {
                ServiceReference3.SilverlightEnabledClient client = new ServiceReference3.SilverlightEnabledClient();
                client.ResultatsCompleted += new EventHandler<ServiceReference3.ResultatsCompletedEventArgs>(client_ResultatsCompleted);
                client.ResultatsAsync("Miami");
                ResultatTextBlock.Text = "En cours...";
            }
            catch (Exception ex)
            {

                MessageBox.Show(ex.Message);
            }

        }

        void client_ResultatsCompleted(object sender, ServiceReference3.ResultatsCompletedEventArgs e)
        {
            Dispatcher.BeginInvoke((Action)delegate()
            {
                try
                {
                    if (e.Error != null)
                    {
                        MessageBox.Show(e.Error.Message, "Une erreur est survenue", MessageBoxButton.OK);
                    }
                    else
                    {
                        ResultatTextBlock.Text = "Terminé";
                        ResultatListBox.ItemTemplate = Resources["MatchTennis"] as DataTemplate;
                        ResultatListBox.ItemsSource = e.Result;
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
            });
        }
        #endregion

        #region Ajax Enabled
        private void AjaxEnabled_Click(object sender, EventArgs e)
        {
            try
            {
                ResultatTextBlock.Text = "En cours...";
                WebRequest request = WebRequest.Create("http://localhost:6330/AjaxEnabled.svc/Calendrier");
                request.BeginGetResponse(AjaxEnabledResponseCallback, request);
            }
            catch (Exception ex)
            {

                MessageBox.Show(ex.Message);
            }
        }
        private void AjaxEnabledResponseCallback(IAsyncResult iar)
        {
            try
            {
                Dispatcher.BeginInvoke((Action)delegate()
                {
                    List<Tournoi> ret = new List<Tournoi>();
                    WebResponse response = ((WebRequest)iar.AsyncState).EndGetResponse(iar);
                    using (XmlReader reader = XmlReader.Create(response.GetResponseStream()))
                    {
                        Tournoi current = null;
                        string name = null;
                        while (reader.Read())
                        {
                            switch (reader.NodeType)
                            {
                                case XmlNodeType.Element:
                                    name = reader.Name;
                                    if (reader.Name == "Tournoi")
                                    {
                                        current = new Tournoi();
                                    }
                                    break;
                                case XmlNodeType.Text:
                                    switch (name)
                                    {
                                        case "Tournoi": break;
                                        case "Nom": current.Nom = reader.Value; break;
                                        case "Sport": current.Sport = reader.Value; break;
                                        case "DateDebut": current.Debut = DateTime.Parse(reader.Value); break;
                                        case "DateFin": current.Fin = DateTime.Parse(reader.Value); break;
                                    }
                                    break;
                                case XmlNodeType.EndElement:
                                    if (reader.Name == "Tournoi")
                                    {
                                        ret.Add(current);
                                        current = null;
                                    }
                                    break;
                            }
                        }
                    }
                    ResultatListBox.ItemTemplate = Resources["Tournoi"] as DataTemplate;
                    ResultatListBox.ItemsSource = ret;
                    ResultatTextBlock.Text = "Terminé";
                });
            }
            catch (Exception ex)
            {

                MessageBox.Show(ex.Message);
            }
        }
        #endregion
    }
}