using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace DemoProgrammez
{
    public class Ball
    {
        private Texture2D _texture;

        public Vector2 Position { get; set; }

        public void LoadContent(ContentManager content)
        {
            _texture = content.Load<Texture2D>(@"ball");
        }

        public void Draw(SpriteBatch spriteBatch)
        {
            spriteBatch.Draw(_texture, Position, Color.White);
        }

        public void GoLeft()
        {
            if (Position.X > 0)
                Position = new Vector2(Position.X - 1, Position.Y);
        }

        public void GoRight()
        {
            if (Position.X + _texture.Width < 480)
                Position = new Vector2(Position.X + 1, Position.Y);
        }
    }
}
